<?php $__env->startSection('title'); ?>
    Admin | SMS Report
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                <div class="card-body card__head">
                    <form method="POST" action="<?php echo e(route('sms-reports.search-sms')); ?>" class="row">
                        <?php echo csrf_field(); ?>
                        <div class="form-group col-lg-3 col-md-4 col-sm-6">
                            <label for="">Search Type</label>
                            <select name="search_value" class="form-control search_value" required>
                                <option value="">Select Option</option>
                                <option value="today" <?php echo e($search_value=='today' ? 'selected' : ''); ?>>Today</option>
                                <option value="pre_month" <?php echo e($search_value=='pre_month' ? 'selected' : ''); ?>>Previous Month</option>
                                <option value="date_range" <?php echo e($search_value=='date_range' ? 'selected' : ''); ?>>Date Range</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3 col-md-4 col-sm-6 date <?php echo e($search_value=='date_range' ? '' : 'd-none'); ?>">
                            <label for="">From Date</label>
                            <input type="text" name="from_date" value="<?php echo e(isset($fromDate) ? date('Y-m-d', strtotime($fromDate)) : ''); ?>" class="form-control date360" readonly>
                        </div>
                        
                        <div class="form-group col-lg-3 col-md-4 col-sm-6 date <?php echo e($search_value=='date_range' ? '' : 'd-none'); ?>">
                            <label for="">To Date</label>
                            <input type="text" name="to_date" value="<?php echo e(isset($toDate) ? date('Y-m-d', strtotime($toDate)) : ''); ?>" class="form-control date360" readonly>
                        </div>
                        <div class="form-group col-lg-3 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info" style="margin-top: 32px!important;">Search</button>
                        </div>
                    </form>

                    <?php if(isset($smsList)): ?>
                <div class="table-responsive" >
                    <table class="table dataTable" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>SL</th>
                                <th>Send From</th>
                                <th>Sent To</th>
                                <th>SMS Text</th>
                                <th>Cost</th>
                                <th>Send Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $total_cost = 0;
                            ?>
                            <?php $__currentLoopData = $smsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $total_cost += $sms->sms_cost;
                                ?>
                                <tr>
                                    <th><?php echo e($loop->iteration); ?></th>
                                    <td><?php echo e($sms->send_from); ?></td>
                                    <td><?php echo e($sms->send_to); ?></td>
                                    <td><?php echo e(urldecode(Str::limit($sms->sms_text, 50))); ?></td>
                                    <td><?php echo e($sms->sms_cost); ?></td>
                                    <td><?php echo e($sms->send_time); ?></td>
                                    <td> <?php echo getStatusBadge($sms->status); ?> </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="table-info">
                                <td colspan="4">Total Cost</td>
                                <td><?php echo e($total_cost); ?></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <?php endif; ?>
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>
<script>
    $(document).ready(function() {
        const today = new Date();
        $('.date360').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,      
            todayHighlight: true, 
        }).datepicker('setDate', today);

        $('.search_value').change(function() {
            dateSearch($(this))
        });
        function dateSearch(_this){
            let search_value = _this.val();
            if(search_value=='date_range'){
                $('.date').removeClass('d-none');
            }else{
                $('.date').addClass('d-none');
            }
        }

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/sms/report.blade.php ENDPATH**/ ?>