
<?php $__env->startSection('title'); ?>
    Admin | Event
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                        <div class="col-md-6">
                            <h6 class="m-0 font-weight-bold text-primary">All Event</h6>
                        </div>
                        <div class="col-md-6">
                            <a href="<?php echo e(route('event.create')); ?>" class="btn btn-primary float-right">Add New</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-12">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Headline</th>
                                        <th>Price</th>
                                        <th class="text-center">Status</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $index++ ?>
                                        <tr>
                                            <td><?php echo e($index); ?></td>
                                            <td><?php echo e(Str::limit($page->headline, 100)); ?></td>
                                            <td><?php echo e($page->price); ?></td>
                                                    
                                            <td class="text-center">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input toggle-class-pub"
                                                        id="customSwitch<?php echo e($page->id); ?>"
                                                        data-id="<?php echo e($page->id); ?>" <?php echo e($page->status == 1 ? 'checked':''); ?>>
                                                    <label class="custom-control-label" for="customSwitch<?php echo e($page->id); ?>"></label>
                                                </div>
                                            </td>
                                            <td class="col__action__body">
                                                
                                                <a href="<?php echo e(route('event.edit', ['id' => $page->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="<?php echo e(route('event.destroy', ['id' => $page->id])); ?>"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_js'); ?>

    <script>
        $(document).ready(function () {
            $('.toggle-class-pub').change(function () {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "<?php echo e(route('changeEventStatus')); ?>",
                    data: {'status': status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });
        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/event/index.blade.php ENDPATH**/ ?>