<?php $__env->startSection('title'); ?>
    Admin | sms
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
        <div class="container-fluid">
            <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2">General SMS</h4>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('general-sms.send')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="col-12 mt-2">
                                    <label class="font-weight-bolder">Sender ID</label>
                                    <div class="form-group">
                                        <input type="text" class="form-control" value="8809617613336" readonly>
                                    </div>
                                </div>
                    
                                <div class="col-12 mt-1">
                                    <label class="font-weight-bolder">Enter Mobile Numbers <span class="text-warning">(Use Comma for number separation. Don't use speace after/before comma.)</span></label>
                                    <fieldset class="form-label-group mb-0">
                                        <textarea data-length="160" class="form-control char-textarea" id="textarea-counter" rows="3"
                                            placeholder="Ex : 01934115336,01870762474" name="mobile_number" required="" style="color: rgb(78, 81, 84);"></textarea>
                                        <label for="textarea-counter"></label>
                                    </fieldset>
                                </div>
                    
                                <div class="col-12 mt-1 mb-2">
                                    <label class="font-weight-bolder">Enter SMS Content </label>
                                    <fieldset class="form-label-group mb-0">
                                        <textarea class="form-control char-textarea" id="message" name="sms_body" rows="3" placeholder="Write your sms body here..."
                                            style="color: rgb(78, 81, 84);"></textarea>
                                        <label for="textarea-counter"></label>
                                    </fieldset>
                                    <small class="sms-count float-left">
                                        <span id="length">0 characters</span> |
                                        <span id="remaining">1530 Characters Left | </span>
                                        <span id="messages" style="color: #f79622;font-weight: bold;"> 1 SMS </span>
                                        <span id="smslen" style="color: #f79622;font-weight: bold;"> ( 160 Char./SMS ) </span>
                                    </small>
                                </div>
                    
                                <div class="col-12">
                                    <button type="submit"
                                        class="btn btn-primary float-right btn-inline mb-2 waves-effect waves-float waves-light">Send
                                        SMS</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    
                </div> <!--col-5-->
            </div>
        </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<script>
    $(document).ready(function () {
        var $remaining = $('#remaining'),
            $length = $('#length'),
            $smslen = $('#smslen'),
            $messages = $remaining.next();


        var $remainingfile = $('#remainingfile'),
            $lengthfile = $('#lengthfile'),
            $smslenfile = $('#smslenfile'),
            $messagesfile = $remainingfile.next();


        var $remaininggroup = $('#remaininggroup'),
            $lengthgroup = $('#lengthgroup'),
            $smslengroup = $('#smslengroup'),
            $messagesgroup = $remaininggroup.next();

        $('#message').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var chars = this.value.length;

            if (msgResponse == false) {
                $("#customRadio1").prop("checked", true);
                console.log(chars);
                if (chars <= 160) {
                    messages = Math.ceil(chars / 160),
                        $length.text(chars + ' characters');
                    $remaining.text((1530 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 160 Char./SMS )');
                } else {
                    messages = Math.ceil(chars / 153),
                        $length.text(chars + ' characters');
                    $remaining.text((1530 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio2").prop("checked", true);
                if (chars <= 70) {
                    messages = Math.ceil(chars / 70),
                        $length.text(chars + ' characters');
                    $remaining.text((670 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 70 Char./SMS )');
                } else {
                    messages = Math.ceil(chars / 67),
                        $length.text(chars + ' characters');
                    $remaining.text((670 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 67 Char./SMS )');
                }

            }

        });


        $('#messagefile').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var charsfile = this.value.length;

            if (msgResponse == false) {
                $("#customRadio4").prop("checked", true);
                // console.log(chars);
                if (charsfile <= 160) {
                    messagesfile = Math.ceil(charsfile / 160),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((1530 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 160 Char./SMS )');
                } else {
                    messagesfile = Math.ceil(charsfile / 153),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((1530 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio6").prop("checked", true);
                if (charsfile <= 70) {
                    messagesfile = Math.ceil(charsfile / 70),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((670 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 70 Char./SMS )');
                } else {
                    messagesfile = Math.ceil(charsfile / 68),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((670 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 68 Char./SMS )');
                }

            }

        });


        $('#messagegroup').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var charsgroup = this.value.length;

            if (msgResponse == false) {
                $("#customRadio3").prop("checked", true);
                // console.log(chars);
                if (charsgroup <= 160) {
                    messagesgroup = Math.ceil(charsgroup / 160),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((1530 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 160 Char./SMS )');
                } else {
                    messagesgroup = Math.ceil(charsgroup / 153),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((1530 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio4").prop("checked", true);
                if (charsgroup <= 70) {
                    messagesgroup = Math.ceil(charsgroup / 70),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((670 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 70 Char./SMS )');
                } else {
                    messagesgroup = Math.ceil(charsgroup / 68),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((670 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 68 Char./SMS )');
                }

            }

        });


    });


    function isDoubleByte(str) {
        for (var i = 0, n = str.length; i < n; i++) {
            // console.log(i)
            //if (str.charCodeAt( i ) > 255 && str.charCodeAt( i )!== 8364 )
            if (str.charCodeAt(i) > 255 ||
                str.charCodeAt(i) == 91 ||
                str.charCodeAt(i) == 92 ||
                str.charCodeAt(i) == 93 ||
                str.charCodeAt(i) == 94 ||
                str.charCodeAt(i) == 123 ||
                str.charCodeAt(i) == 124 ||
                str.charCodeAt(i) == 125 ||
                str.charCodeAt(i) == 126
            ) {
                return true;
            }
        }
        return false;
    }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/back/sms/general_sms_create.blade.php ENDPATH**/ ?>