<?php $__env->startSection('meta_info'); ?>
<title>Blogs | <?php echo e(setting('site_title')); ?></title>
<meta name="description" content="<?php echo e(setting('meta_description')); ?>">
<meta name="keywords" content="<?php echo e(setting('meta_keywords')); ?>">
<meta name="author" content="<?php echo e(setting('meta_author')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="container pb-5 mb-md-2 mb-lg-4">
    <h1 class="border-bottom pb-4">Blogs</h1>
    <div class="row pt-2 pt-md-3">
        <?php
            $posts = all_post_with_pagination(12);
        ?>
        <?php if($posts->isNotEmpty()): ?>
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3">
                    <a href="<?php echo e(news_url($post->id)); ?>" class="nav-link d-inline-block px-0 pt-1 pb-2">
                        <img src="<?php echo e(asset($post->image)); ?>" alt="<?php echo e($post->headline ?? ''); ?>">
                        <p class="fs-lg mb-1"><?php echo e($post->headline ?? ''); ?></p>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4 text-center">Blogs Not Found</p>
            </div>
        <?php endif; ?>
        <?php if($posts->isNotEmpty()): ?>
        <div class="mt-3">
            <?php echo e($posts->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/front/pages/posts.blade.php ENDPATH**/ ?>