
<?php $__env->startSection('title'); ?>
    Admin | Video Index
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

    <style type="text/css">

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid">
        <div class="row justify-content-center">
            <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <rect x="4" y="4" width="6" height="6" rx="1"/>
                                        <rect x="4" y="14" width="6" height="6" rx="1"/>
                                        <rect x="14" y="14" width="6" height="6" rx="1"/>
                                        <line x1="14" y1="7" x2="20" y2="7"/>
                                        <line x1="17" y1="4" x2="17" y2="10"/>
                                    </svg>
                                    All Video
                                </h6>
                            </div>
                            <div class="col-md-2 d-none">
                                <div class="search-box">
                                    <div class="input-group">
                                        <form action="" role="search" class="d-flex"
                                              method="GET" style="margin: 0;">
                                            <input type="text" class="form-control"
                                                   placeholder="Post ID, Headline or Text" name="value">
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8 create__post float-right">
                                <a href="<?php echo e(route('video.create')); ?>" class="btn btn-primary float-right">
                                    Add New</a>
                            </div>
                        </div>

                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th class="text-center">Thumbnail</th>
                                <th>Headline</th>
                                <th class="text-center">View</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"><?php echo e($video->id); ?></td>
                                    <td class="text-center"><img class="profileImgShow" src="<?php echo e($video->thumbnail); ?>"/>
                                    </td>
                                    <td class="post__name"><p><?php echo e(Str::limit($video->title, 55)); ?></p>
                                    </td>
                                    <td class="text-center"><?php echo e($video->view_count); ?></td>
                                    <td class="text-center">
                                        <a title="edit" href="<?php echo e(route('video.edit', ['id' => $video->id])); ?>"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <div class="" style="display: inline-block;">
                                            <form method="POST"
                                                  action="<?php echo e(route('video.destroy', ['id' => $video->id])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input name="_method" type="hidden" value="DELETE">
                                                <button type="submit"
                                                        class="btn btn-danger btn-sm delete_confirm"
                                                        data-toggle="tooltip" title='Delete'>Delete
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            <?php echo e($videos->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/video/video_index.blade.php ENDPATH**/ ?>