
<?php $__env->startSection('title'); ?>
    Admin | Post create
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/css/jquery.tagit.min.css" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" type="text/javascript" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/js/tag-it.min.js" type="text/javascript" charset="utf-8"></script>
<script>
   $(document).ready(function () {
      $('#sticky_position').TouchSpin({
         min: 0,
         max: 500,
         initval: 0,
         boostat: 5,
         maxboostedstep: 10,
         verticalbuttons: true,
      });

      let sticky = $("#sticky");
      sticky.on('click', function () {
          if (sticky.is(':checked')) {
              sticky.val(1);  // checked
              $("#sticky_position_input").css("display", "block");
          } else {
              sticky.val(0);
              $("#sticky_position_input").css("display", "none");
              $("#sticky_position").val('');
          }
      });

      //ajax category subCsategory
      $('#category_list').on('change', function (e) {
          var category_id = e.target.value;
          if (category_id) {
              $.ajax({
                  url: "<?php echo e(route('category.subcategory.ajax')); ?>/" + category_id,
                  type: "get",
                  dataType: "json",
                  success: function (data) {
                      $("#sub_cat_list").empty();
                      $("#sub_cat_list").append('<option selected value="">--Select Sub Category--</option>')
                      $.each(data, function (key, value) {
                          // console.log(value.id);
                          $('#sub_cat_list').append('<option value="' + value.id + '">' + value.name + '</option>')
                      })
                  }
              })
          } else {
          }
      });
   });

 </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
<div class="container-fluid">
    <form role="form" method="post" action="<?php echo e(route('post.update',['id'=>$post->id])); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="m-0 font-weight-bold text-primary">Edit Post</h6>
                            </div>
                            <div class="col-md-6 create__post text-right">
                                <a href="<?php echo e(route('post.index')); ?>" class="btn btn-primary">
                                    View All
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label class="mb-1">Headline</label>
                            <input name="headline" value="<?php echo e($post->headline); ?>" type="text" maxlength="250"
                            class="form-control"
                            required="required">
                        </div>
                        <div class="form-group">
                             <label class="mb-1">Intro</label>
                             <input name="intro" placeholder="Intro" type="text" maxlength="250" class="form-control">
                          </div>

                        <div class="form-group body__edit">
                            <label class="mb-1">Post Content</label>
                            <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                            <textarea id="content24" name="content" class="form-control my-editor"
                            rows="15"><?php echo $post->content; ?></textarea>
                            <script>
                                var editor_config = {
                                    path_absolute: "/",
                                    selector: "#content24",
                                    plugins: [
                                        "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                        "searchreplace wordcount visualblocks visualchars code fullscreen",
                                        "insertdatetime media nonbreaking save table directionality",
                                        "emoticons template paste textcolor colorpicker textpattern"
                                        ],
                                    toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                    relative_urls: false,
                                    file_browser_callback: function (field_name, url, type, win) {
                                        var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                        var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                        var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                        if (type == 'image') {
                                            cmsURL = cmsURL + "&type=Images";
                                        } else {
                                            cmsURL = cmsURL + "&type=Files";
                                        }

                                        tinyMCE.activeEditor.windowManager.open({
                                            file: cmsURL,
                                            title: 'Filemanager',
                                            width: x * 0.8,
                                            height: y * 0.8,
                                            resizable: "yes",
                                            close_previous: "no"
                                        });
                                    }
                                };
                                tinymce.init(editor_config);
                            </script>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="form-group d-none">
                             <label class="m-3">Is Lead?</label>
                             <input type="checkbox" class="m-3" id="sticky" value="0" name="sticky" <?php if($post->sticky == 1): ?> checked="checked" <?php endif; ?>>
                             <?php $leadpost = \App\Models\LeadPost::where('post_id', $post->id)->first(); ?>
                             <div class="" <?php if($post->sticky==1): ?>style="display:block; width: 150px;"<?php else: ?> style="display:none; width: 150px;" <?php endif; ?> id="sticky_position_input">
                                <input class="form-control" id="sticky_position" type="number" name="sticky_position" min="0" <?php if($leadpost): ?> value="<?php echo e($leadpost->position); ?>"<?php endif; ?>>
                             </div>
                             <?php unset($leadpost) ?>
                          </div>
                        <div class="form-group" class="profile-img">
                            <label class="mb-1">Image <span style="color: #f10000; font-weight: bold;">(width: 700px; height: 450px)</span></label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input profile-img-input"  id="photo" name="image">
                                <label class="custom-file-label" for="customFile">Choose file</label>
                            </div>
                            <span class="text-danger"><?php echo e($errors->has('image') ? $errors->first('image'):''); ?></span>
                            <?php if(!empty($post->image)): ?>
                            <div class="pt-1" id="profileLabel" for="photo">
                                <img class="profileImgShow"
                                src="<?php echo e($post->image); ?>">
                            </div>
                            <?php else: ?>
                            <div class="pt-1" id="profileLabel" for="photo">
                                <img class="profileImgShow"
                                src="<?php echo e(asset('defaults/default3.png')); ?>">
                            </div>
                            <?php endif; ?>
                        </div>
                    
                        <div class="form-group">
                            <label for="category_id"> Category <span class="text-danger">*</span></label>
                            <select class="form-control select2-single" id="category_list" name="category_id[]"
                            required="">
                            <?php $__currentLoopData = $post->Category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo $category->id; ?>" selected><?php echo $category->name; ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>"><?php echo $category->name; ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                  <div class="form-group d-none">
                     <label for="sub_cat_id"> Sub Category</label>
                     <select class="form-control select2-single" id="sub_cat_list" name="sub_category_id">
                         <option value="" selected="">Select Sub Category</option>
                     </select>
                  </div>

                        <div class="form-group">
                            <label class="mb-1">Publication status</label>
                            <select class="form-control" name="status">
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="float-right btn btn-primary">Update</button>
                            <a href="<?php echo e(route('post.index')); ?>" class="float-right btn btn-danger mr-2">Cancel</a>
                        </div>
                    </div>
                </div>
            </div> <!--col-->
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/blog/post/edit.blade.php ENDPATH**/ ?>