@extends('layouts.frontend')
@section('meta_info')
<title>Blogs | {{ setting('site_title') }}</title>
<meta name="description" content="{{ setting('meta_description') }}">
<meta name="keywords" content="{{ setting('meta_keywords') }}">
<meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')
<section class="container pb-5 mb-md-2 mb-lg-4">
    <h1 class="border-bottom pb-4">Blogs</h1>
    <div class="row pt-2 pt-md-3">
        @php
            $posts = all_post_with_pagination(12);
        @endphp
        @if ($posts->isNotEmpty())
            @foreach ($posts as $post)
                <div class="col-md-3">
                    <a href="{{ news_url($post->id) }}" class="nav-link d-inline-block px-0 pt-1 pb-2">
                        <img src="{{ asset($post->image)}}" alt="{{$post->headline ?? ''}}">
                        <p class="fs-lg mb-1">{{ $post->headline ?? ''}}</p>
                    </a>
                </div>
            @endforeach
        @else
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4 text-center">Blogs Not Found</p>
            </div>
        @endif
        @if ($posts->isNotEmpty())
        <div class="mt-3">
            {{ $posts->links() }}
        </div>
        @endif
    </div>
</section>
@endsection