@extends('layouts.frontend')
@section('meta_info')
    <title>Blogs | {{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')

    <section class="container pb-5 mb-md-2 mb-lg-4">
        <h1 class="border-bottom pb-4">Blogs</h1>
        @php
            $posts = all_post_with_pagination(12);
        @endphp
        @if ($posts->isNotEmpty())

            <div class="row gy-2">
                @foreach ($posts as $post)
                    <div class="col-md-3 pb-3">
                        <article class="card border-0 shadow-sm h-100">
                            <div class="position-relative">
                                <img src="{{ asset($post->image)}}" alt="{{$post->headline ?? ''}}"
                                     class="img-fluid rounded">
                            </div>
                            <div class="card-body pb-4">
                                <span class="fs-sm text-muted"><i class="bx bx-time"></i> {{ view_date_format($post->created_at,'d F, Y') }}</span>
                                <h5 class="mb-0" style="font-weight: 400;">
                                    <a href="{{ news_url($post->id) }}">{{ Str::limit($post->headline, 50) }}</a>
                                </h5>
                            </div>
                        </article>
                    </div>
                @endforeach
            </div>
        @else
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4 text-center">Blogs Not Found</p>
            </div>
        @endif
        @if ($posts->isNotEmpty())
            <div class="mt-3">
                {{ $posts->links() }}
            </div>
        @endif
    </section>
@endsection