@extends('layouts.backend')
@section('title')
    Admin | sms
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-6">
                            <h4 class="my-2">General SMS List</h4>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                    <tr>
                                    <th>Send From</th>
                                    <th>Sent To</th>
                                    <th>SMS</th>
                                    <th>Cost</th>
                                    <th>Send Time</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total_cost = 0;
                                @endphp
                                @foreach ($generalSmsList as $sms)
                                    @php
                                        $total_cost += $sms->sms_cost;
                                    @endphp
                                    <tr>
                                        {{--<td>{{$sms->send_from}}</td>--}}
                                        <td>DataEnvelope</td>
                                        <td>{{$sms->send_to}}</td>
                                        <td>{{urldecode($sms->sms_text)}}</td>
                                        <td>{{$sms->sms_cost}}</td>
                                        <td>{{$sms->send_time}}</td>
                                        <td> {!! getStatusBadge($sms->status) !!} </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-info">
                                    <td colspan="3">Total Cost</td>
                                    <td>{{$total_cost}}</td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
@endsection
