@extends('layouts.backend')
@section('title')
    Admin | Free shipping
@endsection

@section('extra_css')

    <style type="text/css">
        .btn-sm.btn-icon {
            padding: 8px;
            width: 35px;
            height: 35px;
        }

        .btn-circle {
            border-radius: 50em;
        }

        .btn-soft-success {
            background-color: rgba(10, 187, 117, .15);
            color: #0abb75;
        }

        .btn-soft-success:hover {
            background-color: #0abb75;
            color: #fff;
        }

        .btn-soft-primary {
            background-color: rgba(55, 125, 255, .15);
            color: #377dff;
        }

        .btn-soft-primary:hover {
            background-color: #377dff;
            color: #fff;
        }

        .btn-soft-warning {
            background-color: rgba(255, 197, 25, .15);
            color: #ffc519;
        }

        .btn-soft-warning:hover {
            background-color: #ffc519;
            color: #fff;
        }

        .btn-soft-danger {
            background-color: rgba(239, 72, 106, .15);
            color: #ef486a;
        }

        .btn-soft-danger:hover {
            background-color: #ef486a;
            color: #fff;
        }

        .product__image img {
            border-radius: 5px;
        }
    </style>
@endsection

@section('extra_js')
    <script>
        $(document).ready(function () {

            $('.changeFreeShippingStatus').change(function () {
                var free_shipping_status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                console.log(id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changeFreeShippingStatus') }}",
                    data: {'free_shipping': free_shipping_status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });
        })
    </script>
@endsection

@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-8 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2 d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-brand-asana" width="38" height="38"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <rect x="4" y="4" width="6" height="6" rx="1"/>
                                            <rect x="4" y="14" width="6" height="6" rx="1"/>
                                            <rect x="14" y="14" width="6" height="6" rx="1"/>
                                            <line x1="14" y1="7" x2="20" y2="7"/>
                                            <line x1="17" y1="4" x2="17" y2="10"/>
                                        </svg>
                                        Free Shipping Products
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Product Name</th>
                                        <th class="text-center">Category</th>
                                        <th class="text-center">Stock</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($products as $product)
                                        <tr>
                                            <td class="text-center">{{$product->id}}</td>
                                            <td class="product__name">
                                                <a href="{{ product_url($product) }}" target="_blank">
                                                    <img src="{{ $product->feature_image ? asset('/img/product/feature/'.$product->feature_image): asset('/defaults/avatar02.png')  }}"
                                                         width="50px" class="size-50px img-fit">
                                                    <p>{{ Str::limit($product->product_name, 55) }}</p>
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                @foreach($product->categories->all() as $cat)
                                                    <span class="custom__badge">{{ $cat->name }}</span>
                                                @endforeach
                                            </td>
                                            <td class="text-center">
                                                @if($product->quantity > 0)
                                                    <span>{{ $product->quantity }}</span>
                                                @endif
                                                @if($product->quantity < 10 && $product->quantity > 0)
                                                    <span class="badge bg-danger">Low</span>
                                                @elseif($product->quantity == 0)
                                                    <span class="badge bg-danger">Empty</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <label class="switch">
                                                    <input class="changeFreeShippingStatus" type="checkbox"
                                                           data-id="{{$product->id}}" {{ $product->free_shipping ? 'checked' : '' }}>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                {{ $products->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection


