@extends('layouts.backend')
@section('title')
    Admin
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-10">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row p-3">
                                <div class="col-md-6">
                                    <h4 class=" font-weight-light my-2 float-left">All Roles</h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('permission.create') }}" class="btn btn-primary float-right">Add New Role</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center">ID</th>
                                        <th>Name</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($permissions as $permission)
                                        <tr>
                                            <td class="text-center">{{$permission->id}}</td>
                                            <td>{{$permission->name}}</td>
                                            <td class="text-center">
                                                <a href="{{ route('permission.edit', ['id' => $permission->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('permission.destroy', ['id' => $permission->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
@endsection
