@extends('layouts.backend')
@section('title')
    Admin | Edit Page Category
@endsection
@section('content')

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                      <h6 class="m-0 font-weight-bold text-primary">Edit Category</h6>
                    </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('pagecategory.update',$pagecategory->id) }}"
                                  enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" value="{{ $pagecategory->name }}" placeholder="Enter category name"
                                           type="text"
                                           autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="slug">Name In English <span class="text-danger"></span></label>
                                    <input class=" form-control" name="slug" value="{{ $pagecategory->slug }}" placeholder="Enter category name in english"
                                           type="text" autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('slug') ? $errors->first('slug'):''}}</span>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Update</button>
                        <a href="{{ route('pagecategory.index') }}" class="float-right btn btn-danger mr-2">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Category</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $category = \App\Models\Pagecategory::orderBy('id', 'desc')->Paginate(30); ?>
                                    @foreach($category as $row)
                                        <tr>
                                            <td class="text-center">{{$row->id}}</td>
                                            <td >{{$row->name}}</td>
                                            <td class="col__action__body">
                                                <a href="{{ route('pagecategory.edit', ['id' => $row->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('pagecategory.destroy', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class="pagination px-3 pb-2">
                            {{$category->links()}}
                        </div>
                            </div>
                        
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
@stop

