@extends('layouts.backend')
@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-8">   
            <div class="card">
                <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                    <h5>Edit Event</h5><a class="btn btn-sm btn-primary" href="{{ route('event.index') }}">All Event</a>
                </div>
                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-sm-12 col-md-10 col-lg-10">
                            <form action="{{ route('event.update',$event->id) }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="headline">Headline <span class="text-danger">*</span></label>
                                    <input type="text" name="headline" maxlength="400" value="{{ old('headline', $event->headline ?? '') }}" class="form-control" placeholder="Enter Headline" required>
                                    @error('headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="price">Price <span class="text-danger">*</span></label>
                                    <input type="number" name="price" min="0" value="{{ old('price', $event->price ?? '') }}" class="form-control" placeholder="Enter Price" required>
                                    @error('price')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                    <a href="{{ route('event.index') }}" class="btn btn-secondary">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
