@extends('layouts.backend')
@section('title')
    Admin | View All Posts
@endsection

@section('extra_css')
    <style type="text/css">

    </style>
@endsection

@section('extra_js')

    <script>
        $(document).ready(function () {
            $('.toggle-class-pub').change(function () {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changePublicationStatus') }}",
                    data: {'status': status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });
        })
    </script>

@endsection

@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <rect x="4" y="4" width="6" height="6" rx="1"/>
                                        <rect x="4" y="14" width="6" height="6" rx="1"/>
                                        <rect x="14" y="14" width="6" height="6" rx="1"/>
                                        <line x1="14" y1="7" x2="20" y2="7"/>
                                        <line x1="17" y1="4" x2="17" y2="10"/>
                                    </svg>
                                    All Posts
                                </h6>
                            </div>
                            <div class="col-md-6">
                                <div class="search-box">
                                    <div class="input-group">
                                        <form action="{{ route('post.search') }}" role="search" class="d-flex"
                                              method="GET" style="margin: 0;">
                                            <input type="text" class="form-control"
                                                   placeholder="Post ID, Headline or Text" name="value">
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 create__post float-right">
                                <a href="{{ route('post.create') }}" class="btn btn-primary float-right">
                                    Add New</a>
                            </div>
                        </div>

                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Headline</th>
                                <th>Time</th>
                                <th>Category</th>
                                <th class="text-center">View</th>
                                <th class="text-center">Status</th>
                                <th>Publisher</th>
                                <th class="text-center">Image</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($posts as $post)
                                <tr>
                                    <td class="text-center">{{$post->id}}</td>
                                    <td class="post__name">
                                        <p>{{ Str::limit($post->headline, 55) }}</p>
                                    </td>
                                    <td>{{ Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $post->created_at)->format('H:i/d-m') }}</td>
                                    <td>@foreach($post->Category as $category){{$category->name}}@endforeach</td>
                                    <td class="text-center">{{$post->view_count}}</td>

                                    <td class="text-center">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input toggle-class-pub"
                                                   id="customSwitch{{$post->id}}"
                                                   data-id="{{$post->id}}" {{ $post->status == 1 ? 'checked':'' }}>
                                            <label class="custom-control-label" for="customSwitch{{$post->id}}"></label>
                                        </div>
                                    </td>
                                    <td class="text-center">{{  $post->User?->name }}</td>
                                    <td><img width="80px" src="{{$post->image}}"
                                             class="img-fluid" alt="{{$post->headline}}"></td>
                                    <td class="text-center col__action__body">
                                        <a title="view" target="_blank" href="{{ news_url($post->id) }}"
                                           class="btn btn-success btn-sm">View</a>
                                        <a title="edit" href="{{ route('post.edit', ['id' => $post->id])}}"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <a title="delete" href="{{ route('post.destroy', ['id' => $post->id])}}"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-danger btn-sm">Delete</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            {{$posts->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


