<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('donations', function (Blueprint $table) {
            $table->id();
            $table->string('first_name',255)->nullable();
            $table->string('last_name',255)->nullable();
            $table->string('email',255)->nullable();
            $table->string('phone',25)->nullable();
            $table->json('payment_info')->nullable();  
            $table->decimal('amount', 10, 2)->nullable();
            $table->string('order_id',255)->nullable();
            $table->string('shurjopay_id',255)->nullable();
            $table->string('currency',255)->nullable();
            $table->string('payable_amount',255)->nullable();
            $table->string('discsount_amount',255)->nullable();
            $table->string('disc_percent',255)->nullable();
            $table->string('received_amount',255)->nullable();
            $table->string('usd_amt',255)->nullable();
            $table->string('usd_rate',255)->nullable();
            $table->string('is_verify',255)->nullable();
            $table->string('card_holder_name',255)->nullable();
            $table->string('card_number',255)->nullable();
            $table->string('bank_trx_id',255)->nullable();
            $table->string('invoice_no',255)->nullable();
            $table->string('bank_status',255)->nullable();
            $table->string('customer_order_id',255)->nullable();
            $table->string('sp_code',255)->nullable();
            $table->string('sp_message',255)->nullable();
            $table->string('name',255)->nullable();
            $table->string('address',255)->nullable();
            $table->string('city',255)->nullable();
            $table->string('transaction_status',255)->nullable();
            $table->string('method',255)->nullable();
            $table->string('date_time',255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('donations');
    }
};
