<?php

namespace App\Http\Controllers;

use App\Models\Testimonial;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Testimonial::orderby('id','desc')->get();
        return view('back.testimonial.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.testimonial.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'client_name' => 'required|max:250',
        ]);
        $item = new Testimonial();
        $item->order = $request->order;
        $item->client_name = $request->client_name;
        $item->designation = $request->designation;
        $item->comment = $request->comment;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/testimonial/'), $fileName);
            $item->image = $fileName;
        }
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function show(Testimonial $testimonial)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $item = Testimonial::findOrFail($id);
        return view('back.testimonial.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'client_name' => 'required|max:250',
        ]);
        $item = Testimonial::findOrFail($id);
        $item->order = $request->order;
        $item->client_name = $request->client_name;
        $item->designation = $request->designation;
        $item->comment = $request->comment;
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/testimonial/'), $fileName);
            $item->image = $fileName;
        }
        $item->save();
        return Redirect()->route('testimonial.index')->with('success','Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $item = Testimonial::findOrFail($id);
        $item->delete();
        return Redirect()->route('testimonial.index')->with('success','Deleted successfully');
    }
}
