<?php

namespace App\Http\Controllers;

use App\Models\Event;
use App\Models\PaymentInfo;
use Illuminate\Http\Request;

class PaymentInfoShow extends Controller
{
    public function index(){
        $events = Event::orderBy('id','desc')->get();
        $items = PaymentInfo::where('sp_code',1000)->orderBy('id','desc')->paginate(20);
        return view('back.paymentinfo.index',compact('items','events'));
    }

    public function filter(Request $request){
        $event_id = $request->event_id;
        $events = Event::orderBy('id','desc')->get();
        if($event_id == 0){
            $items = PaymentInfo::where('sp_code',1000)->orderBy('id','desc')->paginate(20);
        }else{
            $items = PaymentInfo::where('sp_code',1000)->where('event_id',$event_id)->orderBy('id','desc')->paginate(20);
        }
        return view('back.paymentinfo.index',compact('items','events','event_id'));
    }
}
