<?php

namespace App\Http\Controllers;

use App\Models\GeneralSetting;
use Illuminate\Http\Request;

class GeneralSettingController extends Controller
{

    public function index(){
        $g_setting = GeneralSetting::find(1);
        return view('back.settings.general_setting', compact('g_setting'));
    }


    public function update(Request $request,  $id){
        $validated = $request->validate([
            'company_full_name' => 'max:200',
            'site_title' => 'max:200',
            'sp_service_charge' => 'numeric|min:0|max:50',
            'admin_prefix' => 'max:15',
        ]);

        // $validated['sp_service_charge'] = intval($validated['sp_service_charge']);

        // dd($validated['sp_service_charge'] );

        $g_setting = GeneralSetting::find($id);
        $g_setting->company_short_name    = $request->company_short_name;
        $g_setting->company_full_name    = $request->company_full_name;
        $g_setting->site_name    = $request->site_name;
        $g_setting->site_title    = $request->site_title;
        $g_setting->facebook    = $request->facebook;
        $g_setting->fb_app_id    = $request->fb_app_id;
        $g_setting->twitter    = $request->twitter;
        $g_setting->linkedin    = $request->linkedin;
        $g_setting->youtube    = $request->youtube;
        $g_setting->instagram    = $request->instagram;

        $g_setting->contact_address    = $request->contact_address;
        $g_setting->contact_phone    = $request->contact_phone;
        $g_setting->contact_email    = $request->contact_email;
        $g_setting->map    = $request->map;

        $g_setting->meta_title    = $request->meta_title;
        $g_setting->meta_description    = $request->meta_description;
        $g_setting->meta_keywords    = $request->meta_keywords;
        $g_setting->meta_author    = $request->meta_author;
        $g_setting->site_url    = $request->site_url;
        $g_setting->seo_title    = $request->seo_title;

        $g_setting->copyright    = $request->copyright;
        $g_setting->sp_service_charge    = $request->sp_service_charge;
        $g_setting->admin_prefix    = $request->admin_prefix;

        // if($request->hasfile('logo')){
        //     $file = $request->file('logo');
        //     $fileName = $file->getClientOriginalName();
        //     // $img = Image::make($file->getRealPath());
        //     // $img->crop($request->w, $request->h, $request->x1, $request->y1);
        //     // $img->save(public_path('/profile/' .$fileName));
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->crop(500, 500);
        //     $image_resize->save(public_path('/settings/' .$fileName));
        //     $g_setting->logo = $fileName;
        // }

        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $fileName = time().'_'.$file->getClientOriginalName();
             $file->move(public_path('settings'), $fileName);
            $g_setting->logo = $fileName;
        }

        if($request->hasfile('favicon')){
            $file = $request->file('favicon');
            $fileName = time().'_'.$file->getClientOriginalName();
             $file->move(public_path('settings'), $fileName);
            $g_setting->favicon = $fileName;
        }

        if($request->hasfile('meta_image')){
            $file = $request->file('meta_image');
            $fileName = time().'_'.$file->getClientOriginalName();
            $file->move(public_path('settings'), $fileName);
            $g_setting->meta_image = $fileName;
        }
        
        if($request->hasfile('lazy_image')){
            $file = $request->file('lazy_image');
            $fileName = time().'_'.$file->getClientOriginalName();
            $file->move(public_path('settings'), $fileName);
            $g_setting->lazy_image = $fileName;
        }

        // if($request->hasfile('lazy_image')){
        //     $date_time = date('YmdHis');
        //     $file = $request->file('lazy_image');
        //     $fileName = $file->getClientOriginalName();
        //     $fileExt = $file->getClientOriginalExtension();
        //     $fileName = $date_time.'.'.$fileExt;
        //     $f_image = '/photos/'.$fileName;
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(700, 450);
        //     $image_resize->save(public_path('/photos/' .$fileName));
        //     $g_setting->lazy_image = $f_image;
        

        //     // $file = $request->file('lazy_image');
        //     // $fileName = time().'_'.$file->getClientOriginalName();
        //     // $file->move(public_path('photos'), $fileName);
        //     // $g_setting->lazy_image = $fileName;
        // }

        $g_setting->save(); 
        return Redirect()->back()->with('success','Update successfully');
    }

}
