<?php

namespace App\Http\Controllers;

use App\Models\Draft;
use App\Models\LeadPost;
use App\Models\VideoGallery;
use App\Models\Category;
use App\Models\Post;
use App\Models\Tag;

use DateTime;
use Auth;
use Image;

use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class DraftController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $draft = Draft::orderby('id','desc')->Paginate(20);
        return view('back.draft.draft_index', compact('draft'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $id)
    {
        $request->validate([
            'headline' => 'required',
            'content' => 'required',
            'category_id' => 'required'
        ]);
        $draft = Draft::find($id);
        if(!empty($draft)){
            $draft = Draft::find($id);
            $draft->category()->detach();
            $draft->Tag()->detach();
            $draft->delete();
        }
        $post = new Post;
        $post->user_id = Auth::user()->id;
        $post->headline = $request->headline;
        $post->intro = $request->intro;
        $post->slug = make_slug($request->headline);
        $post->content = $request->content;
        $date_time = date('YmdHis');

        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileName = $date_time.'.'.$fileExt;
            $f_image = '/blog/'.$fileName;
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(700, 450);
            $image_resize->save(public_path('/blog/' .$fileName));
            $post->image = $f_image;
        }else{
            $post->image = $draft->image;
        }
        $post->status = $request->status;
        $unicode = md5(uniqid(rand(), true));
        $unicode = substr($unicode,2,6);
        $lastPost=Post::orderBy('id','desc')->first();
        $id = $lastPost->id+1;
        $unicode = $unicode.$id;
        $post->unicode = $unicode;
        $post->save();
        if ($request->category_id) {
            $post->Category()->attach($request->category_id);
        }
        if ($request->tag_list) {
            $tags = explode(',', $request->tag_list);
            foreach ($tags as $tag) {
                $item = Tag::firstOrCreate(['name' => $tag]);
                $post->Tag()->attach($item->id);
            }
        }

        $lead_post_position = LeadPost::where('position', $request->sticky_position)->first();
        $lead_post_item = LeadPost::where('post_id', $post->id)->first();
        if ($request->sticky) {
            if ($lead_post_item) {
                $lead_post_item->delete();
            }
            if ($lead_post_position) {
                $leadposts = LeadPost::orderBy('position', 'asc')->get();
                foreach ($leadposts as $leadpost) {
                    if ($leadpost->position == $lead_post_position->position || $leadpost->position > $lead_post_position->position) {
                        $leadpost->position = $leadpost->position + 1;
                        $leadpost->save();
                    }
                }
            }
        } else {
            if ($lead_post_item) {
                $lead_post_item->delete();
            }
        }
        if (!empty($request->sticky_position)) {
            $lead_post = new LeadPost();
            $lead_post->position = $request->sticky_position;
            $lead_post->post_id = $post->id;
            $lead_post->save();
        }

        Session::flash('success', 'Successfully Created');
        return Redirect::route('post.index');
        
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Draft  $draft
     * @return \Illuminate\Http\Response
     */
    public function edit($draft)
    {
        $post = Draft::find($draft);
        $post = Draft::find($draft);
        $categories = Category::orderBy('position','asc')->get();
        $tags = Tag::pluck('name')->toArray();
        return view('back.draft.draft_edit', compact('post', 'categories','tags'));
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Draft  $draft
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $post = Draft::find($id);
        $post->category()->detach();
        $post->Tag()->detach();
        $post->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::back();
    }
}
