<?php

namespace App\Http\Controllers;

use App\Models\Design;
use App\Models\DesignContent;

use DateTime;
use Auth;
use Image;

use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;


class DesignController extends Controller
{
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $designs = Design::orderBy('id','desc')->paginate(20);
        return view('back.design.index', compact('designs'));
    }

    public function show($id){
        $photo = Photo::find($id);
        $photobodies = Photobody::where('design_id',$photo->id)->get();
        // dd($photobodies);
        return view('back.photo.photo_show', compact('photo','photobodies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.design.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|max:200',
            'featured_image' => 'required|max:250',
        ]);
        $photo = new Design;
        $photo->user_id = Auth::user()->id;
        $photo->title = $request->title;
        $photo->slug = make_slug($request->title);
        $photo->featured_image = $request->featured_image;
        $photo->save();
        foreach($request->thumbnail as $index => $photo_detail){
            $photo_body = new DesignContent;
            $photo_body->design_id  = $photo->id;
            $photo_body->thumbnail = $request->thumbnail[$index];
            $photo_body->caption = $request->caption[$index];
            $photo_body->save();
        }
        Session::flash('success', 'Successfully Added');
        return Redirect::to(route('design.index'));
    }

    public function edit($id)
    {   
        $photo = Design::find($id);
        $photobody = DesignContent::where('design_id',$photo->id)->first();
        $photobodies = DesignContent::where('design_id',$photo->id)->get();
        $photobodies = $photobodies->skip(1);

        return view('back.design.edit', compact('photo','photobody','photobodies'));
    }

    public function update(Request $request, $id)
    {
        $photo = Design::find($id);
        $request->validate([
            'title' => 'required',
            'featured_image' => 'required',
        ]);
        $photobody = DesignContent::where('design_id',$photo->id)->get();
        foreach($photobody as $body){
            $body->delete();
        }
        $photo->user_id = Auth::user()->id;
        $photo->title = $request->title;
        $photo->slug = make_slug($request->title);
        $photo->featured_image = $request->featured_image;
        $photo->save();
        foreach($request->thumbnail as $index => $photo_detail){
            $photo_body = new DesignContent;
            $photo_body->design_id  = $photo->id;
            $photo_body->thumbnail = $request->thumbnail[$index];
            $photo_body->caption = $request->caption[$index];
            $photo_body->save();
        }
        Session::flash('success', 'Successfully Updated');
        return Redirect::to(route('design.index'));
    }

   
    public function destroy( $id)
    {
        $photo = Design::find($id);
        $photobody = DesignContent::where('design_id',$photo->id)->get();
        foreach($photobody as $body){
            $body->delete();
        }
        $photo->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::to(route('design.index'));
    }
}
