<?php

namespace App\Http\Controllers;

use App\Models\Message;
use App\Models\ContactMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;

class ContactMessageController extends Controller
{
    public function index(){
        $messages = ContactMessage::orderBy('id', 'desc')->Paginate(10);
        return view('back.message.index',compact('messages'));
    }
    public function view($id){
        $item = ContactMessage::findOrFail($id);
        return view('back.message.view', compact('item'));
    }
    public function destroy($id){
        $item = ContactMessage::findOrFail($id);
        $item->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::route('message.index');
    }
}
