@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}"/>
    <meta name="keywords" content="{{ $setting->meta_keywords }}"/>
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{$setting->meta_author}}">
    <meta property="og:title" content="{{ $setting->meta_title }}"/>
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
    <meta property="og:url" content="{{$setting->site_url}}"/>
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}"/>
    <meta name="twitter:title" content="{{ $setting->meta_title }}"/>
    <meta name="twitter:description" content="{{ $setting->meta_description }}"/>
    <meta name="twitter:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
@endsection
@section('css')
    <style>
        /*.form-control[readonly]{*/
        /*    cursor: not-allowed; !* Change cursor to indicate it's not editable *!*/
        /*    background-color: #e0e0e0; !* Light grey background to show it's disabled *!*/
        /*    color: #796f6f; !* Grey text color to show it's inactive *!*/
        /*}*/


    </style>
@endsection
@section('content')
    @php
        $event = active_event();
        $amount = $event->price ?? 0;
        $sp_service_charge = setting('sp_service_charge');
        $serviceCharge = floatval($sp_service_charge);
        $serviceCharge2 = $amount / 100;
        $serviceCharge3 = $serviceCharge2 * $serviceCharge;
        $grand_total = $amount + $serviceCharge3;
    @endphp

    <section class="sec__payment bg-secondary position-relative">
        <div class="container">
            <div class="title text-center mb-5">
                <h1 class=""><span class="text-gradient-primary">{{$event->headline ?? ''}}</span></h1>
                <h5>9 March, 2025</h5>
                <h5 class="h5 mb-1" style="font-weight: 400">Venue</h5>
                <img src="/img/bg/Lakeshore-Heights-logo.png" class="img-fluid text-center" style="width: 150px;"/>
            </div>
            <div class="row">
                <div class="col-md-6 pb-2 pb-md-0 mb-4 mb-md-0">
                    <div class="pe-lg-5">
                        <img src="assets/img/bg/img1.jpg" class="rounded-3" alt="Image">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="row justify-content-center text-center payment__header">
                        {{--                    <p class="mb-0">Like what you have seen? Let’s get started. Just fill in a few details and we--}}
                        {{--                        will get in touch as soon as possible.</p>--}}
                        <h4>Payment Information</h4>
                    </div>

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0 p-0">
                                @foreach($errors->all() as $error)
                                    <li class="list-group-item">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <div class="payment__form mt-3">
                        <form class="row needs-validation " method="POST" action="{{ route('payment') }}">
                            @csrf

                            <div class="col-sm-6 mb-3">
                                <label for="fn" class="form-label">First Name <span class="text-danger">*</span></label>
                                <input type="text" id="fn"
                                       class="form-control @error('first_name') field-invalid @enderror"
                                       value="{{ old('first_name') }}" name="first_name" maxlength="100" required>
                                @error('first_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-sm-6 mb-3">
                                <label for="ln" class="form-label">Last Name <span class="text-danger">*</span></label>
                                <input type="text" id="ln"
                                       class="form-control @error('last_name') field-invalid @enderror"
                                       value="{{ old('last_name') }}" name="last_name" maxlength="100" required>
                                @error('last_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-6 mb-3">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" id="email"
                                       class="form-control @error('email') field-invalid @enderror"
                                       value="{{ old('email') }}" name="email" maxlength="100" required>
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-6 mb-3">
                                <label for="phone" class="form-label">Phone No <span
                                            class="text-danger">*</span></label>
                                <input type="text" id="phone"
                                       class="form-control @error('phone') field-invalid @enderror"
                                       value="{{ old('phone') }}" name="phone" maxlength="18"
                                       oninput="formatPhoneNum(this)" required>
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12 mb-3">
                                <label for="address" class="form-label">Address <span
                                            class="text-danger">*</span></label>
                                <input type="text" id="address"
                                       class="form-control @error('address') field-invalid @enderror"
                                       value="{{ old('address') }}" name="address" maxlength="100" required>
                                @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-6 mb-3">
                                <label for="city" class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" id="city" class="form-control @error('city') field-invalid @enderror"
                                       value="{{ old('city') }}" name="city" maxlength="50" required>
                                @error('city')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-6 mb-3">
                                <label for="hotel_name" class="form-label">Hotel Name</label>
                                <input type="hidden" value="{{$event->id ?? 0 }}" name="event_id">
                                <input type="text" id="hotel_name"
                                       class="form-control @error('hotel_name') field-invalid @enderror"
                                       value="{{ old('hotel_name') }}" name="hotel_name" maxlength="250">
                                @error('hotel_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-12 amount__bl">
                                <div class="d-flex align-items-center justify-content-start">
                                    <label for="amount" class="form-label mb-0" style="width: 342px;">Registration
                                        Fee: </label>
                                    <span class="me-2">Tk. </span>
                                    <input type="number" id="amount"
                                           class="form-control @error('amount') field-invalid @enderror"
                                           value="{{ $event->price ?? 0 }}" readonly name="amount" step="0.01" min="0"
                                           required>
                                </div>
                                @error('amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            {{--<div class="col-12 mb-3">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="form-label">Service Charge <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" value="{{ $sp_service_charge ?? 0 }}" readonly min="0" max="100">
                                    </div>

                                    <div class="col-md-4">
                                        <label class="form-label">Grand Total <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" value="{{ $grand_total ?? 0 }}" readonly min="0">
                                    </div>
                                </div>
                            </div>--}}

                            <div class="col-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked"
                                           required>
                                    <label class="form-check-label" for="flexCheckChecked">
                                        I agree to the <a href="/terms-condition" target="_blank">Terms & Condition</a>.
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 text-center pt-2 pt-md-3 pt-lg-4">
                                <button type="submit" class="btn btn-outline-primary">Continue <i
                                            class="bx bx-right-arrow-alt fs-xl ms-2"></i></button>
                            </div>
                        </form>
                    </div>
                </div>

                {{--                <div class="col-lg-10 m-auto py-4 mt-5">--}}
                {{--                    <img src="/img/surjopay.png" class="img-fluid"/>--}}
                {{--                </div>--}}
            </div>
        </div>
        <div class="position-absolute end-0 bottom-0 text-primary">
            <svg width="169" height="103" viewBox="0 0 469 343" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path opacity="0.08" fill-rule="evenodd" clip-rule="evenodd"
                      d="M273.631 680.872C442.436 768.853 639.315 708.216 717.593 558.212C795.871 408.208 732.941 212.157 564.137 124.176C395.333 36.195 198.453 96.8326 120.175 246.836C41.8972 396.84 104.827 592.891 273.631 680.872ZM236.335 752.344C440.804 858.914 688.289 788.686 789.109 595.486C889.928 402.286 805.903 159.274 601.433 52.7043C396.964 -53.8654 149.479 16.3623 48.6595 209.562C-52.1598 402.762 31.8652 645.774 236.335 752.344Z"
                      fill="currentColor"></path>
                <path opacity="0.08" fill-rule="evenodd" clip-rule="evenodd"
                      d="M298.401 633.404C434.98 704.59 598.31 656.971 664.332 530.451C730.355 403.932 675.946 242.827 539.367 171.642C402.787 100.457 239.458 148.076 173.435 274.595C107.413 401.114 161.822 562.219 298.401 633.404ZM288.455 652.464C434.545 728.606 611.369 678.429 683.403 540.391C755.437 402.353 695.402 228.725 549.312 152.583C403.222 76.4404 226.398 126.617 154.365 264.655C82.331 402.693 142.365 576.321 288.455 652.464Z"
                      fill="currentColor"></path>
            </svg>
        </div>
    </section>
    <section class="container py-5 sec__venue d-none">
        <div class="row mt-lg-3 pt-1 pt-md-4 pt-lg-5">
            <div class="col-xl-3 col-md-4 text-center text-md-start">
                <h3 class="h4">Venue</h3>
                <img src="/img/bg/Lakeshore-Heights-logo.png" class="img-fluid text-center"/>
                <h2 class="h1 mb-2 mb-lg-4">Lakeshore Heights</h2>
                <h5 class="mb-2 mb-lg-2">Address:</h5>
                <p>House # 03, Road # 126, Gulshan Avenue, Gulshan-1, Dhaka-1212, Bangladesh</p>
                <div class="d-none d-md-block text-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="118" height="118" fill="none">
                        <g clip-path="url(#A)">
                            <path d="M116.912 76.527c-4.963-3.081-9.413-6.675-13.52-10.782-1.37-1.369-3.766-.343-3.766 1.54 0 1.54-.171 3.081-.171 4.621-14.89 2.739-29.78 3.936-45.013 4.108-12.836.342-30.123 1.712-41.761-4.45-8.9-4.792-10.269-15.917-6.504-24.475 1.54-3.594 4.279-6.504 7.702-8.557 3.936-2.396 7.873-1.027 11.981-2.054.513-.171.685-.856.342-1.369-6.333-6.675-17.457 1.027-21.565 6.504-5.819 7.702-6.161 18.998-1.027 27.042 7.531 11.981 25.501 11.125 37.653 11.467 19.169.685 39.365.171 58.192-4.108 0 1.712.171 3.252.685 4.963 0 .342.171.513.342.685-1.369 1.198-.171 4.279 2.225 3.765 4.963-1.027 9.927-2.568 14.548-4.792 1.198-1.026.856-3.251-.343-4.107zm-13.178-4.45c2.396 2.054 4.792 4.108 7.531 5.99-2.396 1.027-4.964 1.712-7.531 2.396v-.685c-.514-2.567-.342-5.135 0-7.702z"
                                  fill="currentColor"></path>
                        </g>
                        <defs>
                            <clipPath id="A">
                                <path fill="#fff" d="M0 0h118v118H0z"></path>
                            </clipPath>
                        </defs>
                    </svg>
                </div>
            </div>
            <div class="col-xl-9 col-md-8">
                <img src="/img/bg/bg1.jpg" class="rounded-3" width="952" alt="Hoteliers Venue">
            </div>
        </div>
        <div class="row mb-lg-3 pb-1 pb-md-4 pb-lg-5 mt-4 mt-sm-n5">
            <div class="col-lg-4 col-md-5 offset-md-6 offset-lg-7 mt-md-n5">
                <div class="gallery mt-md-n4 mx-auto" style="max-width: 416px;">
{{--                    <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3651.0588208980703!2d90.41582020475464!3d23.780919649563042!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c7507a5c0e2d%3A0xa05d83e301b66609!2sLakeshore%20Heights!5e0!3m2!1sen!2sbd!4v1740651127181!5m2!1sen!2sbd"--}}
{{--                            width="800" height="600" style="border:0;" allowfullscreen="" loading="lazy"--}}
{{--                            referrerpolicy="no-referrer-when-downgrade"></iframe>--}}
                    <a href="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3651.0588208980703!2d90.41582020475464!3d23.780919649563042!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c7507a5c0e2d%3A0xa05d83e301b66609!2sLakeshore%20Heights!5e0!3m2!1sen!2sbd!4v1740651127181!5m2!1sen!2sbd"
                       data-iframe="true" class="gallery-item rounded-2"
                       data-sub-html="<h6 class=&quot;fs-sm text-light&quot;>Javits Center, NY, USA</h6>"
                       data-lg-id="3d74ab9f-a1e5-47a9-bada-a1b3a9e419d6">
                        <img src="/img/bg/map2.jpg" class="d-dark-mode-none d-none d-lg-block"
                             alt="Map preview">
                        <span class="btn btn__map d-block d-lg-none">Location Map</span>
                        <div class="gallery-item-caption fs-sm fw-medium">Lakeshore Heights, Gulshan-1, Dhaka-1212</div>
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section class="sec__sponsor py-5">
        <div class="container">
            <h2 class="h1 sec__heading text-center pb-4 mb-1 mb-lg-3">Our Sponsors</h2>
            <div class="position-relative px-xl-5">

                <!-- Slider prev/next buttons -->
                <button type="button" id="prev-news"
                        class="btn btn-prev btn-icon btn-sm position-absolute start-0 translate-middle-y d-none d-xl-inline-flex"
                        aria-label="Previous slide" tabindex="0" aria-controls="swiper-wrapper-10b65a7529e9b2d9b">
                    <i class="bx bx-chevron-left"></i>
                </button>
                <button type="button" id="next-news"
                        class="btn btn-next btn-icon btn-sm position-absolute end-0 translate-middle-y d-none d-xl-inline-flex"
                        aria-label="Next slide" tabindex="0" aria-controls="swiper-wrapper-10b65a7529e9b2d9b">
                    <i class="bx bx-chevron-right"></i>
                </button>

                <!-- Slider -->
                <div class="px-xl-2">
                    <div class="swiper mx-n2 swiper-initialized swiper-horizontal swiper-pointer-events swiper-backface-hidden"
                         data-swiper-options="{
                &quot;slidesPerView&quot;: 2,
                &quot;loop&quot;: true,
                &quot;pagination&quot;: {
                  &quot;el&quot;: &quot;.swiper-pagination&quot;,
                  &quot;clickable&quot;: true
                },
                &quot;navigation&quot;: {
                  &quot;prevEl&quot;: &quot;#prev-news&quot;,
                  &quot;nextEl&quot;: &quot;#next-news&quot;
                },
                &quot;breakpoints&quot;: {
                  &quot;500&quot;: {
                    &quot;slidesPerView&quot;: 2
                  },
                  &quot;1000&quot;: {
                    &quot;slidesPerView&quot;: 5
                  }
                }
              }">
                        <div class="swiper-wrapper"
                             style="transform: translate3d(-800px, 0px, 0px); transition-duration: 0ms;"
                             id="swiper-wrapper-10b65a7529e9b2d9b" aria-live="polite">

                            <!-- Item -->
                            <div class="swiper-slide h-auto pb-3 swiper-slide-duplicate-active"
                                 data-swiper-slide-index="0" style="width: 400px;" role="group" aria-label="4 / 4">
                                <article class="card h-100 border-0 shadow-sm mx-2">
                                    <div class="position-relative">
                                        <img src="/img/sponsor/cl1.jpg" class="card-img-top"
                                             alt="Image">
                                    </div>
                                </article>
                            </div>

                            <div class="swiper-slide h-auto pb-3 swiper-slide-duplicate-active"
                                 data-swiper-slide-index="1" style="width: 400px;" role="group" aria-label="4 / 4">
                                <article class="card h-100 border-0 shadow-sm mx-2">
                                    <div class="position-relative">
                                        <img src="/img/sponsor/cl2.jpg" class="card-img-top"
                                             alt="Image">
                                    </div>
                                </article>
                            </div>
                            <div class="swiper-slide h-auto pb-3 swiper-slide-duplicate-active"
                                 data-swiper-slide-index="2" style="width: 400px;" role="group" aria-label="4 / 4">
                                <article class="card h-100 border-0 shadow-sm mx-2">
                                    <div class="position-relative">
                                        <img src="/img/sponsor/cl3.jpg" class="card-img-top"
                                             alt="Image">
                                    </div>
                                </article>
                            </div>
                            <div class="swiper-slide h-auto pb-3 swiper-slide-duplicate-active"
                                 data-swiper-slide-index="3" style="width: 400px;" role="group" aria-label="4 / 4">
                                <article class="card h-100 border-0 shadow-sm mx-2">
                                    <div class="position-relative">
                                        <img src="/img/sponsor/cl4.jpg" class="card-img-top"
                                             alt="Image">
                                    </div>
                                </article>
                            </div>
                            <div class="swiper-slide h-auto pb-3 swiper-slide-duplicate-active"
                                 data-swiper-slide-index="4" style="width: 400px;" role="group" aria-label="4 / 4">
                                <article class="card h-100 border-0 shadow-sm mx-2">
                                    <div class="position-relative">
                                        <img src="/img/sponsor/cl5.jpg" class="card-img-top"
                                             alt="Image">
                                    </div>
                                </article>
                            </div>
                        </div>

                        <!-- Pagination (bullets) -->
                        <div class="swiper-pagination position-relative bottom-0 mt-4 mb-lg-2 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">
                            <span class="swiper-pagination-bullet" tabindex="0" role="button"
                                  aria-label="Go to slide 1"></span><span class="swiper-pagination-bullet" tabindex="0"
                                                                          role="button"
                                                                          aria-label="Go to slide 2"></span><span
                                    class="swiper-pagination-bullet" tabindex="0" role="button"
                                    aria-label="Go to slide 3"></span><span
                                    class="swiper-pagination-bullet swiper-pagination-bullet-active" tabindex="0"
                                    role="button" aria-label="Go to slide 4" aria-current="true"></span></div>
                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span></div>
                </div>
            </div>
        </div>
    </section>

    <section class="payment__logo text-center">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <img src="/img/surjopay.png" class="img-fluid"/>
                </div>
            </div>
        </div>
    </section>
@endsection 