
<?php $__env->startSection('title'); ?>
    Admin | Page Category
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                      <h6 class="m-0 font-weight-bold text-primary">Add Category</h6>
                    </div>
                        <div class="card-body">
                            <form role="form" method="post" action="<?php echo e(route('pagecategory.store')); ?>"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" placeholder="Enter category name"
                                           type="text"
                                           autocomplete="off">
                                    <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="slug">Name In English <span class="text-danger"></span></label>
                                    <input class=" form-control" name="slug" placeholder="Enter category name in english"
                                           type="text" autocomplete="off">
                                    <span class="text-danger"><?php echo e($errors->has('slug') ? $errors->first('slug'):''); ?></span>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Category</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $category = \App\Models\Pagecategory::orderBy('id', 'desc')->Paginate(30); ?>
                                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($row->id); ?></td>
                                            <td ><?php echo e($row->name); ?></td>
                                            <td class="col__action__body">
                                                <a href="<?php echo e(route('pagecategory.edit', ['id' => $row->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="<?php echo e(route('pagecategory.destroy', ['id' => $row->id])); ?>"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <div class="pagination px-3 pb-2">
                            <?php echo e($category->links()); ?>

                        </div>
                            </div>
                        
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/pagecategory/index.blade.php ENDPATH**/ ?>