
<?php $__env->startSection('title'); ?>
    Admin | Menu Setup
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

    <style type="text/css">

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
<div class="container-fluid">
    <div class="row justify-content-center">
        <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Add Menu</h6>
                </div>
                <div class="card-body">
                    <form role="form" method="post" action="<?php echo e(route('menu.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input class=" form-control" name="name" placeholder="Name" type="text"required>
                            <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                        </div>

                        <div class="form-group">
                            <label for="url">URL <span class="text-danger">*</span></label>
                            <input class=" form-control" name="url" placeholder="URL" type="text"required>
                            <span class="text-danger"><?php echo e($errors->has('url') ? $errors->first('url'):''); ?></span>
                        </div>

                        <div class="form-group">
                            <label for="possition">Position <span class="text-danger"></span></label>
                            <input class="form-control" id="position" type="number" name="position" placeholder="Position" min="0">
                            <span class="text-danger"><?php echo e($errors->has('position') ? $errors->first('position'):''); ?></span>
                        </div>

                        <button type="submit" class="float-right btn btn-primary">Create</button>
                    </form>
                </div>
            </div>
        </div> <!--col-6-->

        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">All Menu</h6>
                </div>
                <div class="table-responsive">
                    <table class="table align-items-center table-flush">
                        <thead class="thead-light">
                            <tr>
                                <th>Name</th>
                                <th>URL</th>
                                <th class="text-center">Position</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $items = \App\Models\Menu::orderBy('position', 'ASC')->Paginate(30); ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($row->name); ?></td>
                                <td><?php echo e($row->url); ?></td>
                                <td class="text-center"><?php echo e($row->position); ?></td>
                                <td class="col__action__body">
                                    <a title="edit" href="<?php echo e(route('menu.edit', ['id' => $row->id])); ?>" class="btn btn-info btn-sm">Edit</a>
                                    <a href="<?php echo e(route('menu.delete', ['id' => $row->id])); ?>" onclick="return confirm('Are you sure to delete this!')" class="btn btn-danger btn-sm">Delete</a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="pagination px-3 pb-2">
                        <?php echo e($items->links()); ?>

                    </div>
                </div>
            </div>
        </div> <!--col-6-->
    </div>
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/menu/menu_create.blade.php ENDPATH**/ ?>