<?php $__env->startSection('title'); ?>
    Admin | All Fund Raise Information
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
    <style>
        .modal-dialog.custom {
            max-width: 60%;
        }

        .custom .table td, .table th {
            border: 1px solid #e3e6f0;
        }

        @media (max-width: 992px) {
            .modal-dialog.custom {
                max-width: 90% !important;
                margin: 1.75rem auto;
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
    <script>
        // Script to dynamically populate the modal with item details
        $(document).on('click', '.view-btn', function () {
            var itemId = $(this).data('id');
            var itemName = $(this).data('name');
            var itemPhone = $(this).data('phone');
            var itemEmail = $(this).data('email');
            var itemAddress = $(this).data('address');
            var itemCity = $(this).data('city');
            var itemDate = $(this).data('date');

            var itemAmount = $(this).data('amount');
            var itemReceivedAmount = $(this).data('received_amount');
            var itemOrderId = $(this).data('order_id');
            var itemMethod = $(this).data('method');
            var itemInvoice = $(this).data('invoice');
            var itemSpMessage = $(this).data('sp_message');
            var itemCurrency = $(this).data('currency');

            // Populate modal with item details in a table
            $('#itemId').text(itemId);
            $('#itemName').text(itemName);
            $('#itemPhone').text(itemPhone);
            $('#itemEmail').text(itemEmail);
            $('#itemAddress').text(itemAddress);
            $('#itemCity').text(itemCity);
            $('#itemDate').text(itemDate);


            $('#itemAmount').text(itemAmount);
            $('#itemReceivedAmount').text(itemReceivedAmount);
            $('#itemOrderId').text(itemOrderId);
            $('#itemMethod').text(itemMethod);
            $('#itemInvoice').text(itemInvoice);
            $('#itemSpMessage').text(itemSpMessage);
            $('#itemCurrency').text(itemCurrency);

            // Show modal
            $('#viewModal').modal('show');
        });

        document.getElementById('eventSelect').addEventListener('change', function () {
            var eventId = this.value;
            if (eventId >= 0) {
                document.getElementById('paymentFilterForm').submit();
            }
        });

    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row justify-content-center">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <rect x="4" y="4" width="6" height="6" rx="1"/>
                                        <rect x="4" y="14" width="6" height="6" rx="1"/>
                                        <rect x="14" y="14" width="6" height="6" rx="1"/>
                                        <line x1="14" y1="7" x2="20" y2="7"/>
                                        <line x1="17" y1="4" x2="17" y2="10"/>
                                    </svg>
                                    All Fund Raise Information
                                </h6>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Name</th>
                                <th class="text-center">Phone</th>
                                <th>Email</th>
                                <th>City</th>
                                <th class="text-center">Amount</th>
                                <th class="text-center">Gateway</th>
                                <th class="col__action__body text-center">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center"><?php echo e($item->id); ?></td>
                                    <td><?php echo e($item->name); ?></td>
                                    <td><?php echo e($item->phone); ?></td>
                                    <td><?php echo e($item->email); ?></td>
                                    <td><?php echo e($item->city); ?></td>
                                    <td class="text-center"><?php echo e($item->amount); ?></td>
                                    <td class="text-center"><?php echo e($item->method); ?></td>
                                    <td class="text-center col__action__body">
                                        <a href="javascript:void(0)"
                                           class="btn btn-success btn-sm view-btn"
                                           data-id="<?php echo e($item->shurjopay_id); ?>"
                                           data-name="<?php echo e($item->name); ?>"
                                           data-phone="<?php echo e($item->phone); ?>"
                                           data-email="<?php echo e($item->email); ?>"
                                           data-address="<?php echo e($item->address); ?>"
                                           data-city="<?php echo e($item->city); ?>"
                                           data-date="<?php echo e($item->date_time); ?>"
                                           data-amount="<?php echo e($item->payable_amount); ?>"
                                           data-received_amount="<?php echo e($item->received_amount); ?>"
                                           data-order_id="<?php echo e($item->order_id); ?>"
                                           data-method="<?php echo e($item->method); ?>"
                                           data-invoice="<?php echo e($item->invoice_no); ?>"
                                           data-sp_message="<?php echo e($item->sp_message); ?>"
                                           data-currency="<?php echo e($item->currency); ?>"
                                        >
                                            View
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">No payment information available</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            <?php echo e($items->links('pagination::bootstrap-4')); ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
         aria-hidden="true">
        <div class="modal-dialog custom" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Payment Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Container for two columns -->
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th>SP ID</th>
                                    <td id="itemId"></td>
                                </tr>
                                <tr>
                                    <th>Name</th>
                                    <td id="itemName"></td>
                                </tr>
                                <tr>
                                    <th>Phone</th>
                                    <td id="itemPhone"></td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td id="itemEmail"></td>
                                </tr>
                                <tr>
                                    <th>Address</th>
                                    <td id="itemAddress"></td>
                                </tr>
                                <tr>
                                    <th>City</th>
                                    <td id="itemCity"></td>
                                </tr>

                                <tr>
                                    <th>Date</th>
                                    <td id="itemDate"></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- Second Column -->
                        <div class="col-md-6">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th>Payable Amount</th>
                                    <td id="itemAmount"></td>
                                </tr>
                                <tr>
                                    <th>Received Amount</th>
                                    <td id="itemReceivedAmount"></td>
                                </tr>
                                <tr>
                                    <th>Order ID</th>
                                    <td id="itemOrderId"></td>
                                </tr>
                                <tr>
                                    <th>Getway</th>
                                    <td id="itemMethod"></td>
                                </tr>
                                <tr>
                                    <th>Invoice No</th>
                                    <td id="itemInvoice"></td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td id="itemSpMessage"></td>
                                </tr>
                                <tr>
                                    <th>Currency</th>
                                    <td id="itemCurrency"></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/HoteliersBD2/resources/views/back/donation/index.blade.php ENDPATH**/ ?>