@extends('layouts.frontend')
@section('css')
<style>
    .form-control[readonly]{
        cursor: not-allowed; /* Change cursor to indicate it's not editable */
        background-color: #e0e0e0; /* Light grey background to show it's disabled */
        color: #796f6f; /* Grey text color to show it's inactive */
    }
</style>
@endsection
@section('content')
@php
    $event = active_event();
    $amount = $event->price ?? 0;
    $sp_service_charge = setting('sp_service_charge');
    $serviceCharge = floatval($sp_service_charge);
    $serviceCharge2 = $amount / 100;
    $serviceCharge3 = $serviceCharge2 * $serviceCharge;
    $grand_total = $amount + $serviceCharge3;
    
@endphp

<section class="sec__payment bg-secondary position-relative">
    <div class="container">
        <div class="row">
            <div class="col-md-6 pb-2 pb-md-0 mb-4 mb-md-0">
                <div class="pe-lg-5">
                    <img src="assets/img/bg/img1.jpg" class="rounded-3" alt="Image">
                </div>
            </div>
            <div class="col-md-6">

                {{-- <form method="POST"  action="{{route('shurjopay.lara')}}">
                    @csrf
                    <input class="favorite styled" type="submit" value="Submit">
                </form>  --}}

                <div class="row justify-content-center text-center">
                    <h1 class="mb-4"><span class="text-gradient-primary">Payment</span> Information</h1>
                    <p class="mb-0">Like what you have seen? Let’s get started. Just fill in a few details and we
                        will get in touch as soon as possible.</p>
                    <h4>{{$event->headline ?? ''}}</h4>    
                </div>

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0 p-0">
                                @foreach($errors->all() as $error)
                                    <li class="list-group-item">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                <form class="row needs-validation " method="POST" action="{{ route('payment') }}">
                    @csrf

                    <div class="col-sm-6 mb-3">
                        <label for="fn" class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" id="fn" class="form-control @error('first_name') field-invalid @enderror" value="{{ old('first_name') }}" name="first_name" maxlength="100" required>
                        @error('first_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-sm-6 mb-3">
                        <label for="ln" class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" id="ln" class="form-control @error('last_name') field-invalid @enderror" value="{{ old('last_name') }}" name="last_name" maxlength="100" required>
                        @error('last_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-6 mb-3">
                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                        <input type="email" id="email" class="form-control @error('email') field-invalid @enderror" value="{{ old('email') }}" name="email" maxlength="100" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-6 mb-3">
                        <label for="phone" class="form-label">Phone No <span class="text-danger">*</span></label>
                        <input type="text" id="phone" class="form-control @error('phone') field-invalid @enderror" value="{{ old('phone') }}" name="phone" maxlength="18" oninput="formatPhoneNum(this)" required>
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-6 mb-3">
                        <label for="hotel_name" class="form-label">Hotel Name</label>
                        <input type="hidden" value="{{$event->id ?? 0 }}" name="event_id">
                        <input type="text" id="hotel_name" class="form-control @error('hotel_name') field-invalid @enderror" value="{{ old('hotel_name') }}" name="hotel_name" maxlength="250">
                        @error('hotel_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-6 mb-3">
                        <label for="city" class="form-label">City</label>
                        <input type="text" id="city" class="form-control @error('city') field-invalid @enderror" value="{{ old('city') }}" name="city" maxlength="50">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                
                    <div class="col-12 mb-3">
                        <label for="address" class="form-label">Address</label>
                        <input type="text" id="address" class="form-control @error('address') field-invalid @enderror" value="{{ old('address') }}" name="address" maxlength="100">
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-12">
                        <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
                        <input type="number" id="amount" class="form-control @error('amount') field-invalid @enderror" value="{{ $event->price ?? 0 }}" readonly name="amount"  step="0.01" min="0" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    {{--<div class="col-12 mb-3">
                        <div class="row">
                            
                            <div class="col-md-4">
                                <label class="form-label">Service Charge <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" value="{{ $sp_service_charge ?? 0 }}" readonly min="0" max="100">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Grand Total <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" value="{{ $grand_total ?? 0 }}" readonly min="0">
                            </div>
                        </div>
                    </div>--}}
                    <div class="col-12 text-center pt-2 pt-md-3 pt-lg-4">
                        <button type="submit" class="btn btn-outline-primary">Continue</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="position-absolute end-0 bottom-0 text-primary">
        <svg width="169" height="103" viewBox="0 0 469 343" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path opacity="0.08" fill-rule="evenodd" clip-rule="evenodd"
                  d="M273.631 680.872C442.436 768.853 639.315 708.216 717.593 558.212C795.871 408.208 732.941 212.157 564.137 124.176C395.333 36.195 198.453 96.8326 120.175 246.836C41.8972 396.84 104.827 592.891 273.631 680.872ZM236.335 752.344C440.804 858.914 688.289 788.686 789.109 595.486C889.928 402.286 805.903 159.274 601.433 52.7043C396.964 -53.8654 149.479 16.3623 48.6595 209.562C-52.1598 402.762 31.8652 645.774 236.335 752.344Z"
                  fill="currentColor"></path>
            <path opacity="0.08" fill-rule="evenodd" clip-rule="evenodd"
                  d="M298.401 633.404C434.98 704.59 598.31 656.971 664.332 530.451C730.355 403.932 675.946 242.827 539.367 171.642C402.787 100.457 239.458 148.076 173.435 274.595C107.413 401.114 161.822 562.219 298.401 633.404ZM288.455 652.464C434.545 728.606 611.369 678.429 683.403 540.391C755.437 402.353 695.402 228.725 549.312 152.583C403.222 76.4404 226.398 126.617 154.365 264.655C82.331 402.693 142.365 576.321 288.455 652.464Z"
                  fill="currentColor"></path>
        </svg>
    </div>
</section>
@endsection