@extends('layouts.backend')
@section('title')
    Admin | Bloger list
@endsection

@section('extra_css')

@endsection

@section('extra_js')
<script>
    $(document).ready(function () {
        $('.changeUserStatus').change(function () {
            var status = $(this).prop('checked') == true ? 1 : 0;
            var id = $(this).data('id');
            console.log(id);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                dataType: "json",
                url: "{{ route('changeUserStatus') }}",
                data: {'status': status, 'id': id},
                success: function (data) {
                    toastr.success(data.success)
                }
            });
        });

    })
</script>
@endsection

@section('content')
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-11">
                    <div class="card mb-4">
                        <div class="row d-flex justify-content-between">
                            <div class="col-md-6 col-lg-6 mb-2">
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                              <h6 class="m-0 font-weight-bold text-primary">Bloger List</h6>
                            </div>
                            </div>
                            <div class="col-md-6 col-lg-6 mb-2">
                                <div class="card-header py-3 d-flex flex-row float-right">
                                  <div class="search-box">
                                        <div class="input-group">
                                            <form action="{{ route('author.list.search')}}" role="search"
                                                  class="d-flex" method="GET" style="margin: 0;">
                                                <input type="text" class="form-control"
                                                       placeholder="Type & Hit Enter (Name, Email)" name="search" required
                                                       style="height: 44px">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>    
                        <div class="table-responsive">
                            <table class="table align-items-center table-flush">
                                <thead class="thead-light">
                                <tr>
                                <tr>
                                    <th class="text-center col__id">ID</th>
                                    <th>Name</th>
                                    <th>User</th>
                                    <th class="text-center">Photo</th>
                                    <th class="text-center">Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $users = \App\Models\User::where('role','writer')->orderBy('id', 'asc')->Paginate(30); ?>
                                @foreach($users as $row)
                                    <tr>
                                        <td class="text-center">{{$row->id}}</td>
                                        <td>{{$row->name}}</td>
                                        <td>{{$row->email}}</td>
                                        <td class="text-center"><img class="img-profile rounded-circle" width="50" src="{{$row->photo ? asset('/profile/'.$row->photo) : asset('/defaults/avatar01.png')}}"></td>
                                        <td class="text-center">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input changeUserStatus" id="customSwitch{{$row->id}}" data-id="{{$row->id}}" {{ $row->status ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="customSwitch{{$row->id}}"></label>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            <div class="pagination px-3 pb-2">
                                {{$users->links()}}
                            </div>
                        </div>
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
    
@endsection
