@extends('layouts.backend')
@section('title')
    Admin
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')

<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header py-3  align-items-center justify-content-between">
                    <div class="row">
                        <div class="col-md-6">
                            <h4 class="my-2 d-flex align-items-center">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                class="icon icon-tabler icon-tabler-award" width="28" height="28"
                                viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                <circle cx="12" cy="9" r="6"/>
                                <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                transform="rotate(-30 12 9)"/>
                                <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                transform="rotate(30 12 9)"/>
                            </svg>
                            Edit Account
                        </h4>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('admin.index') }}" class="btn btn-primary float-right">View All</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form role="form" method="post" action="{{ route('admin.update',['id'=>$admin->id]) }}" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="name">Name <span class="text-danger">*</span></label>
                        <input class=" form-control" name="name" value="{{$admin->name}}" placeholder="Name" type="text" autocomplete="off" required>
                        <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                    </div>
                    <div class="form-group">
                        <label for="email">Email <span class="text-danger">*</span></label>
                        <input class="form-control" type="email" name="email" value="{{$admin->email}}" placeholder="Email" autocomplete="off" required>
                        <span class="text-danger">{{ $errors->has('email') ? $errors->first('email'):''}}</span>
                    </div>
                    <div class="form-group ">
                    <label for="role">Role <span class="text-danger">*</span></label>
                        <select class="form-control" name="role" required>
                            <option value="">--Select Role--</option>
                            <option value="superadmin" {{ $admin->role == 'superadmin' ? 'selected' : '' }}>Super Admin</option>
                            <option value="admin" {{ $admin->role == 'admin' ? 'selected' : '' }}>Admin</option>
                            <option value="user" {{ $admin->role == 'user' ? 'selected' : '' }}>User</option>
                        </select>
                        <span class="text-danger">{{ $errors->has('role') ? $errors->first('role'):''}}</span>
                    </div>
                    <div class="form-group">
                        <label for="password">Password <span
                            class="text-danger">*</span></label>
                            <input class="form-control" type="password" name="password" placeholder="Password" autocomplete="off" required>
                            <span class="text-danger">{{ $errors->has('password') ? $errors->first('password'):''}}</span>
                        </div>
                        <div class="form-group">
                            <label for="password">Confirm Password <span
                                class="text-danger">*</span></label>
                                <input class="form-control" type="password" name="confirm_password"
                                placeholder="Confirm Password" autocomplete="off" required>
                                <span class="text-danger">{{ $errors->has('password') ? $errors->first('password'):''}}</span>
                            </div>
                            <div class="form-group">
                                <label for="photo">Photo <small>(200x200)</small></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input profile-img-input"  id="photo" name="photo">
                                    <label class="custom-file-label" for="customFile">Choose file</label>
                                </div>
                                <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                                <div class="pt-1" id="profileLabel" for="photo">
                                    <img class="profileImgShow" src="{{ $admin->photo ? asset('profile/'.$admin->photo) : asset('defaults/default3.png')}}">
                                </div>
                            </div>
                            <button type="submit" class="float-right btn btn-success">Update</button>
                            <a href="{{ route('admin.index') }}" class="float-right btn btn-danger mr-2">Cancel</a>
                        </form>
                    </div>
                </div>
            </div> <!--col-5-->
        </div>
    </div>
@endsection
