@extends('layouts.backend')
@section('title')
    Admin | All staffs
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="my-2 d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-award" width="28" height="28"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <circle cx="12" cy="9" r="6"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(-30 12 9)"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(30 12 9)"/>
                                        </svg>
                                        All Staffs
                                    </h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('staff.create') }}" class="btn btn-primary float-right">Add New
                                        Staff</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center">ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th class="text-center">Phone</th>
                                        <th class="text-center">Role</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if(!empty($staffs))
                                        @foreach($staffs as $key => $staff)
                                            <tr>
                                                <td class="text-center">{{$staff->id}}</td>
                                                <td>{{$staff->user->name}}</td>
                                                <td>{{$staff->user->email}}</td>
                                                <td class="text-center">{{$staff->user->phone}}</td>
                                                <td class="text-center">{{$staff->role->name}}</td>
                                                <td class="text-center col__action__body">
                                                    <a title="edit"
                                                       href="{{ route('staff.edit', ['id' => $staff->id])}}"
                                                       class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i
                                                                class="fa fa-edit"></i></a>
                                                    <a title="delete"
                                                       href="{{ route('staff.destroy', ['id' => $staff->id])}}"
                                                       onclick="return confirm('Are you sure to delete this!')"
                                                       class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i
                                                                class="fa fa-trash"></i> </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
@endsection
