@extends('layouts.backend')
@section('title')
    Admin | All Category
@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                      <h6 class="m-0 font-weight-bold text-primary">Add Category</h6>
                    </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('category.store') }}"
                                  enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" placeholder="Enter category name"
                                           type="text"
                                           autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="slug">Name In English <span class="text-danger"></span></label>
                                    <input class=" form-control" name="slug" placeholder="Enter category name in english"
                                           type="text" autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('slug') ? $errors->first('slug'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="possition">Position <span
                                                class="text-danger"></span></label>
                                        <input class="form-control" type="number" min="0" name="position" placeholder="Enter position (lower number has high priority)"
                                               id="position">
                                        <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                                </div>

                                <div class="form-group">
                                     <label class="mb-1">Photo</label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input" id="photo" name="icon">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger">{{ $errors->has('icon') ? $errors->first('icon'):''}}</span>
                                     <div class="pt-1" id="profileLabel" for="photo">
                                        <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                                     </div>
                                  </div>
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Category</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th class="text-center col__pos">Position</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $category = \App\Models\Category::orderBy('position', 'asc')->Paginate(30); ?>
                                    @foreach($category as $row)
                                        <tr>
                                            <td class="text-center">{{$row->id}}</td>
                                            <td>
                                                <img class="feature_image" src="{{ $row->icon?asset('/img/category-thumb/'.$row->icon):asset('defaults/def__img.png')}}">
                                                {{$row->name}}
                                            </td>
                                            <td class="text-center">{{$row->position}}</td>
                                            <td class="col__action__body">
                                                <a href="{{ route('category.edit', ['id' => $row->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('category.delete', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class="pagination px-3 pb-2">
                            {{$category->links()}}
                        </div>
                            </div>
                        
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
    
@endsection
