<?php

namespace App\Http\Controllers;

use App\Models\SystemSetting;
use Illuminate\Http\Request;
use Auth;
class SystemSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s_setting = SystemSetting::OrderBy('id','desc')->first();
        // dd($s_setting );
        return view('back.settings.system_setting', compact('s_setting'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SystemSetting  $systemSetting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $s_setting = SystemSetting::find($id);
        // dd($s_setting);
        $s_setting->user_id    = Auth::user()->id;
        $s_setting->delivery_charge    = $request->delivery_charge;
        $s_setting->save();
        return Redirect()->back()->with('success','Updated successfully');
    }

   
}