<?php

namespace App\Http\Controllers\Payment;

use App\Http\Controllers\Controller;

use App\Models\Event;
use App\Models\PaymentInfo;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    
    public function serviceCharge($amount=0){
        $sp_service_charge = setting('sp_service_charge');
        $serviceCharge = floatval($sp_service_charge);
        $serviceCharge2 = $amount / 100;
        $serviceCharge3 = $serviceCharge2 * $serviceCharge;
        $grand_total = $amount + $serviceCharge3;
        return $grand_total;
    }

    public function payment(Request $request)
    {
        $validated = $request->validate([
            'first_name' => 'required|string|max:100',
            'last_name' => 'required|string|max:100',
            'email' => 'required|string|max:100',
            'phone' => 'required|string||regex:/^\d{5}-\d{6}$/|max:18',
            'hotel_name' => 'nullable|string|max:250',
            'amount' => 'required|integer|max:1000000',
            'event_id' => 'required|integer',
            'city' => 'nullable|string|max:50',
            'address' => 'nullable|string|max:100',
        ]);
        // Cast the 'amount' to an integer
        $validated['amount'] = intval($validated['amount']);
        $validated['event_id'] = intval($validated['event_id']);
        // If the event_id doesn't exist, validation will fail with a custom message
        $event = Event::find($request->event_id);
        if (!$event) {
            return back()->withErrors(['event_id' => 'Event not found.'])->withInput();
        }
        // dd($validated);
        try {
            $merchant_name = config('surjopay.merchant_name');
            $merchant_password = config('surjopay.merchant_password');
            $url = 'https://sandbox.shurjopayment.com/api/get_token';
            //For Live Use 'https://engine.shurjopayment.com/api/get_token';

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                "username": "'.$merchant_name.'",
                "password": "'.$merchant_password.'",
                "type": "json"
            }',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);

            $responseObject = json_decode($response, true);

            if (isset($responseObject['token']) && $responseObject['token'] != null) {
                $res = $this->createPayment($responseObject, $request);

                if (isset($res['checkout_url']) && $res['checkout_url'] != null) {
                    return redirect()->away($res['checkout_url']);
                    //For Inertia Js, Use this to avoid whole tab opening as modal
//                 return inertia()->location($res['checkout_url']);
                }else{
                    return redirect()->route('frontend')->with('error','Payment Generation Failed');
                }
            }else{
                return redirect()->route('frontend')->with('error','Token Generation Failed');
            }
        }catch (\Exception $exception){
            return $exception->getMessage();
        }

    }

    protected function createPayment($response, Request $request)
    {
        // get all form request value
        $first_name = $request->first_name;
        $last_name = $request->last_name;
        $email = $request->email;
        $phone = $request->phone;
        $hotel_name = $request->hotel_name;
        $city = $request->city ?? 'N/A';
        $address = $request->address ?? 'N/A';
        $amount = Event::find($request->event_id)->price;
        $event_id = $request->event_id;
        $grand_total = $this->serviceCharge($amount);
        // dd($response, $address);
        try {
            $url = 'https://sandbox.shurjopayment.com/api/secret-pay';
            //For Live Use 'https://engine.shurjopayment.com/api/secret-pay';

            $token      = $response['token'];
            $store_id   = $response['store_id'];
            $authorizationToken = "Bearer $token";
            $order_id = rand(000000000000,999999999999);
            // dd($address );
            session()->put('token', $token);

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                "prefix": "sp",
                "token": "'.$token.'",
                "return_url": "'.route('success').'",
                "cancel_url": "'.route('cancel').'",
                "store_id": "'.$store_id.'",
                "amount": "'.$grand_total.'",
                "order_id": "'.$order_id.'",
                "currency": "BDT",
                "customer_name": "'.$first_name.' '.$last_name.'",
                "customer_address": "'.$address.'",
                "customer_phone": "'.$phone.'",
                "customer_city": "'.$city.'",
                "customer_post_code": "N/A",
                "client_ip": "N/A",
                "discount_amount": "",
                "disc_percent": "",
                "customer_email": "'.$email.'",
                "customer_state": "N/A",
                "customer_postcode": "N/A",
                "customer_country": "N/A",
                "shipping_address": "N/A",
                "shipping_city": "N/A",
                "shipping_country": "N/A",
                "received_person_name": "N/A",
                "shipping_phone_number": "'.$phone.'",
                "value1": "'.$hotel_name.'",
                "value2": "'.$event_id.'",
                "value3": "'.$first_name.'",
                "value4": "'.$last_name.'",
                "type": "json"
            }',
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: $authorizationToken",
                ),
            ));

            $res = curl_exec($curl);

            curl_close($curl);

            $resObject = json_decode($res, true);
            // dd($resObject );
            return $resObject;

        }catch (\Exception $e){
            return $e->getMessage();
        }
    }

    public function success(Request $request)
    {
        // dd($request->all(),'event');
        try {
            if (isset($request['order_id']) && $request['order_id'] != null) {
                $url = 'https://www.sandbox.shurjopayment.com/api/verification';
                //For Live Use 'https://www.engine.shurjopayment.com/api/verification';
                $token = session()->get('token');
                $order_id      = $request['order_id'];
                $authorizationToken = "Bearer $token";

                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS =>'{
                        "order_id": "'.$order_id.'",
                        "type": "json"
                    }',
                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: $authorizationToken",
                    ),
                ));
                $res = curl_exec($curl);

                dd($curl,$res);
                curl_close($curl);

                $resObject = json_decode($res, true); //succes result
                $resArray = $resObject[0];

                // "value1": "'.$hotel_name.'",
                // "value2": "'.$event_id.'",
                // "value3": "'.$first_name.'",
                // "value4": "'.$last_name.'",

                $shurjopay_id = $resArray['id'];
                $order_id = $resArray['order_id'];
                $currency = $resArray['currency'];
                $amount = $resArray['amount'];
                $payable_amount = $resArray['payable_amount'];
                $discsount_amount = $resArray['discsount_amount'];
                $disc_percent = $resArray['disc_percent'];
                $received_amount = $resArray['received_amount'];
                $usd_amt = $resArray['usd_amt'];
                $usd_rate = $resArray['usd_rate'];
                $is_verify = $resArray['is_verify'];
                $card_holder_name = $resArray['card_holder_name'];
                $card_number = $resArray['card_number'];
                $phone_no = $resArray['phone_no'];
                $bank_trx_id = $resArray['bank_trx_id'];
                $invoice_no = $resArray['invoice_no'];
                $bank_status = $resArray['bank_status'];
                $customer_order_id = $resArray['customer_order_id'];
                $sp_code = $resArray['sp_code'];
                $sp_message = $resArray['sp_message'];
                $name = $resArray['name'];
                $email = $resArray['email'];
                $address = $resArray['address'];
                $city = $resArray['city'];
                $hotel_name = $resArray['value1'];
                $event_id = $resArray['value2'];
                $first_name = $resArray['value3'];
                $last_name = $resArray['value4'];
                $transaction_status = $resArray['transaction_status'];
                $method = $resArray['method'];
                $date_time = $resArray['date_time'];

                //Store payment transaction and order details
                $PaymentInfo = PaymentInfo::create([
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'phone' => $phone_no,
                    'hotel_name' => $hotel_name,
                    'payment_info' => json_encode($resArray),
                    'amount' => $amount,
                    'order_id' => $order_id,
                    'event_id' => $event_id,
                    'shurjopay_id' => $shurjopay_id,
                    'currency' => $currency,
                    'payable_amount' => $payable_amount,
                    'discsount_amount' => $discsount_amount,
                    'disc_percent' => $disc_percent,
                    'received_amount' => $received_amount,
                    'usd_amt' => $usd_amt,
                    'usd_rate' => $usd_rate,
                    'is_verify' => $is_verify,
                    'card_holder_name' => $card_holder_name,
                    'card_number' => $card_number,
                    'bank_trx_id' => $bank_trx_id,
                    'invoice_no' => $invoice_no,
                    'bank_status' => $bank_status,
                    'customer_order_id' => $customer_order_id,
                    'sp_code' => $sp_code,
                    'sp_message' => $sp_message,
                    'name' => $name,
                    'address' => $address,
                    'city' => $city,
                    'transaction_status' => $transaction_status,
                    'method' => $method,
                    'date_time' => $date_time,
                ]);
                session()->forget('token');
                return redirect()->route('frontend')->with('success','Your payment was successfully completed. We appreciate your transaction!');
            }
        }catch (\Exception $exception){
            return $exception->getMessage();
        }
    }

    public function cancel(Request $request)
    {
        return redirect()->route('frontend')->with('error','Payment Cancelled!');
    }

}
