<?php

namespace App\Http\Controllers;

use App\Models\Partner;
use Illuminate\Http\Request;

use DateTime;
use Auth;
use Image;
use Carbon\Carbon;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class PartnerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $partners = Partner::orderBy('position','asc')->get();
        return view('back.partner.index',compact('partners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.partner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:250',
            'short_brief' => 'required',
        ]);
        $partner =  new Partner();
        $partner->name     = $request->name;
        $partner->slug     = make_slug($request->name);
        $partner->short_brief     = $request->short_brief;
        $partner->position     = $request->position;
        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/partner/'), $fileName);
            $partner->logo = $fileName;
        }
        $partner->save();
        return Redirect()->back()->with('success',  'inserted successfully');
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $partner = Partner::find($id);
        return view('back.partner.edit', compact('partner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $request->validate([
            'name' => 'required|max:250',
            'short_brief' => 'required',
        ]);
        $partner =  Partner::find($id);
        $partner->name     = $request->name;
        $partner->slug     = make_slug($request->name);
        $partner->short_brief     = $request->short_brief;
        $partner->position     = $request->position;
        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/partner/'), $fileName);
            $partner->logo = $fileName;
        }
        $partner->save();
        return Redirect()->route('partner.index')->with('success',  'updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $partner =   Partner::find($id);   
        $partner->delete();
        return Redirect()->route('partner.index')->with('success',  'deleted successfully');
    }
}
