<?php

namespace App\Http\Controllers;

use App\Models\Pagecategory;
use Illuminate\Http\Request;

class PagecategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $pagecategory = Pagecategory::orderBy('id','desc')->get();
        return view('back.pagecategory.index',compact('pagecategory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250|unique:pagecategories',
            'slug' => 'string|max:250|unique:pagecategories',
        ]);
        $category = new Pagecategory();
        $category->name = $request->name;
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        $category->save();
        return redirect()->route('pagecategory.index')->with('success', 'Page Category created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Pagecategory $pagecategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $pagecategory = Pagecategory::find($id);
        return view('back.pagecategory.edit',compact('pagecategory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,  $id)
    {
        $category = Pagecategory::find($id);
        $request->validate([
            'name' => 'required|string|unique:pagecategories,name,'.$category->id.',id',
            'slug' => 'unique:pagecategories,slug,'.$category->id.',id',
        ]);
        
        $category->name = $request->name;
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        $category->save();
        return redirect()->route('pagecategory.index')->with('success', 'Page Category update successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $category = Pagecategory::find($id);
        $total = $category->page->count();
        if(empty($total)){
            $category->delete();
            return redirect()->route('pagecategory.index')->with('success', 'Page Category deleted successfully.');
        }else{
            return redirect()->route('pagecategory.index')->with('danger', 'This record related other table.');
        }        
    }
}
