<?php

namespace App\Http\Controllers\Front;

use App\Models\Post;
use App\Models\Category;
use App\Models\ContactMessage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function home(){
        return view('front.pages.home');
    }

    public function posts(){
        return view('front.pages.posts');
    }

    public function singlePost($category, $id)
    {   
        $post = Post::find($id);
        if($post->status == 1){
            $category = Category::where('slug', $category)->select('id','name')->first();
            if($post != null && $category!= null){
                $post->view_count = $post->view_count + 1;
                $post->save();
                return view('front.pages.single_post', compact('post', 'category'));
            }else{
                return view('errors.my_404');
            }
        }
        return view('errors.my_404');
    }
    
    public function about(){
        return view('front.pages.about');
    }
    public function contact(){
        return view('front.pages.contact');
    }
    public function privacy(){
        return view('front.pages.privacy');
    }
    public function terms(){
        return view('front.pages.terms');
    }

    public function message(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:30',
            'email' => 'required|string|max:100',
            'message' => 'required|string|max:300',
        ]);
        $mess = new ContactMessage();
        $mess->name     = $validated['name'];
        $mess->email     = $validated['email'];
        $mess->message     = $validated['message'];
        $mess->save();
        return Redirect()->back()->with('success',  'The query was successfully sent.');
    }
    
}
