<?php

namespace App\Http\Controllers;

use App\Models\Message;
use Illuminate\Http\Request;
use DateTime;
use Auth;
use Image;
use File;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class ContactMessageController extends Controller
{
    public function index(){
        return view('back.message.index');
    }
    public function view($id){
        $item = Message::findOrFail($id);
        return view('back.message.view', compact('item'));
    }
    public function destroy($id){
        $item = Message::findOrFail($id);
        $item->delete();
        Session::flash('success', 'Successfully Deleted');
        return Redirect::route('message.index');
    }
}
