<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;
use Image;
use File;

use Illuminate\Support\Facades\Session;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('back.category.category_index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.category.category_index');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:100',
        ]);

        $category = new Category();

        $category->name = $request->name;
        
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $id = Category::orderby('id','desc')->first();
            if($id == null){
                $category->position = 1;
            }else{
                $category->position = $id->position+1;
            }
        }else{
            $category->position = $request->position;
        }
        
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;

        // if($request->hasfile('icon')){
            
        //     $file = $request->file('icon');
        //     $fileName = $file->getClientOriginalName();
            
        //     // $img = Image::make($file->getRealPath());
        //     // $img->crop($request->w, $request->h, $request->x1, $request->y1);
        //     // $img->save(public_path('/profile/' .$fileName));

        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(50, 50);
        //     $image_resize->save(public_path('/img/category-thumb/' .$fileName));
        //     $category->icon = $fileName;
        // }


        if($request->hasfile('icon')){
            $file = $request->file('icon');
            $fileName = $file->getClientOriginalName();
             $file->move(public_path('/img/category-thumb/'), $fileName);
            $category->icon = $fileName;
        }

        $category->save();
        return Redirect()->back()->with('success',  'Category inserted successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
       $category = Category::find($id);
       return view('back.category.category_edit', compact('category'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $category = Category::find($id);
        $request->validate([
            'name' => 'required|max:100',
        ]);

        $category->name = $request->name;
        
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $category->position = $category->id;
        }else{
            $category->position = $request->position;
        }
        
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;

        // if($request->hasfile('icon')){
            
        //     $file = $request->file('icon');
        //     $fileName = $file->getClientOriginalName();
            
        //     // $img = Image::make($file->getRealPath());
        //     // $img->crop($request->w, $request->h, $request->x1, $request->y1);
        //     // $img->save(public_path('/profile/' .$fileName));

        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->resize(50, 50);
        //     $image_resize->save(public_path('/img/category-thumb/' .$fileName));
        //     $category->icon = $fileName;
        // }

        if($request->hasfile('icon')){
            $file = $request->file('icon');
            $fileName = $file->getClientOriginalName();
            $file->move(public_path('/img/category-thumb/'), $fileName);
            $category->icon = $fileName;
        }

        $category->save();
        return Redirect()->route('category.create')->with('success',  'Category updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cat = Category::find($id);
        $total = Product::where('category_id',$cat->id)->get()->count();
        // dd($total);
        if($total == 0){
            $category = Category::find($id);
            if(File::exists(public_path('/img/category-thumb/'.$category->icon))){
                File::delete(public_path('/img/category-thumb/'.$category->icon));
            }
            $category->delete();
            Session::flash('success', 'Category deleted successfully');
        } else {
            Session::flash('danger', 'Sorry, this record related some other tables');
        }
        return Redirect()->route('category.create');

    }

    public function changeHomePage(Request $request){
        $category = Category::find($request->id);
        $category->home_page = $request->home_page;
        $category->save();
        return response()->json(['success'=>'Home page status change successfully.']);
    }

    
}
