<?php

namespace App\Http\Controllers;

use App\Models\Ad;
use Illuminate\Http\Request;

use Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;

class AdController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('back.ad.ad_index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:200',
            'photo' => 'required|max:200',
        ]);

        $ad =  new Ad();

        $ad->user_id     = Auth::user()->id;
        $ad->name     = $request->name;
        $ad->url     = $request->url;
        $ad->position     = $request->position;

        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/ads/'), $fileName);
            $ad->photo = $fileName;
        }


        // if(!empty($request->content)){
        //     $long_descrip_content = $request->content;
        //     $long_descrip_doc = new \DomDocument();
        //     $long_descrip_doc->loadHtml($long_descrip_content, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD); //true
        //     $imageFile = $long_descrip_doc->getElementsByTagName('img'); //file count
        //     foreach($imageFile as $item => $image){
        //         $data = $image->getAttribute('src');
        //         list($type, $data) = explode(';', $data);
        //         list(, $data)      = explode(',', $data);
        //         $imgeData = base64_decode($data);
        //         $time = time();
        //         $image_name= "/ads/" . $time.$item.'.png';
        //         $image_name_f_database = url('/')."/ads/" . $time.$item.'.png';
        //         $path = public_path(). $image_name;
        //         // dd( $path );
        //         file_put_contents($path, $imgeData);
        //         $image->removeAttribute('src');
        //         $image->setAttribute('src', $image_name_f_database);
        //     }
        //     $long_descrip_content = $long_descrip_doc->saveHTML();
        //     $ad->content     = $long_descrip_content;
        // }

        $ad->save();
        return Redirect()->back()->with('success',  'Advertisement inserted successfully');

    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $ad = Ad::find($id);
        // dd($ad);
        return view('back.ad.ad_edit', compact('ad'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $request->validate([
            'name' => 'required|max:200',
        ]);
        $ad =   Ad::find($id);

        $ad->user_id     = Auth::user()->id;
        $ad->name     = $request->name;
        $ad->url     = $request->url;
        $ad->position     = $request->position;

        if($request->hasfile('photo')){
            $file = $request->file('photo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('/ads/'), $fileName);
            $ad->photo = $fileName;
        }

        //ad content
            // if(!empty($request->content)){
            //     $long_descrip_content = $request->content;
            //     $long_descrip_doc = new \DomDocument();
            //     $long_descrip_doc->loadHtml($long_descrip_content, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD); //true
            //     $imageFile = $long_descrip_doc->getElementsByTagName('img'); //file count

            //     // dd($imageFile );
            //     if(!empty($imageFile)){
            //         foreach($imageFile as $item => $image){
            //             $data = $image->getAttribute('src');
            //             // dd($data );
            //             if(!empty($data)){

            //             list($type, $data) = explode(' ', $data);
            //             list($type, $data) = explode(';', $data);
            //             list(, $data)      = explode(',', $data);
            //             }
            //             $imgeData = base64_decode($data);
            //             $time = time();
            //             $image_name= "/ads/" . $time.$item.'.png';
            //             $image_name_f_database = url('/')."/ads/" . $time.$item.'.png';
            //             $path = public_path(). $image_name;
            //             // dd( $path );
            //             file_put_contents($path, $imgeData);
            //             $image->removeAttribute('src');
            //             $image->setAttribute('src', $image_name_f_database);
            //         }
            //     }
                
            //     $long_descrip_content = $long_descrip_doc->saveHTML();
            //     $ad->content     = $long_descrip_content;
            // }

        $ad->save();
        return Redirect()->route('ad.index')->with('success',  'Advertisement updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ad =   Ad::find($id);   
        $ad->delete();
        return Redirect()->route('ad.index')->with('success',  'Advertisement deleted successfully');
    }
}
