@extends('layouts.backend')
@section('title')
    Admin | Password Reset
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')
    <script type="text/javascript">
    </script>
@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header"><h4 class="text-center text-primary font-weight-bold my-1">Password Reset</h4>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('user.password.update') }}">
                                @csrf
                                <div class="form-group">
                                    <label for="current_password">Current Password <span
                                                class="text-danger">*</span></label>
                                    <input class=" form-control" name="current_password" value=""
                                           placeholder="Current Password" type="password" autocomplete="off"
                                           required>
                                    <span class="text-danger">{{ $errors->has('current_password') ? $errors->first('current_password'):''}}</span>
                                    @if(Session::has('current_pass'))<span class="text-danger">{{ Session::get('current_pass') }}</span>@endif
                                </div>
                                <div class="form-group">
                                    <label for="password">New Password <span
                                                class="text-danger">*</span></label>
                                    <input class=" form-control" name="password" value="" placeholder="New Password"
                                           type="password" autocomplete="off" required>
                                    <span class="text-danger">{{ $errors->has('password') ? $errors->first('password'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="confirm_password">Confirm Password <span
                                                class="text-danger">*</span></label>
                                    <input class=" form-control" name="confirm_password" value=""
                                           placeholder="Confirm Password" type="password" autocomplete="off"
                                           required>
                                    <span class="text-danger">{{ $errors->has('confirm_password')?"The password & confirm password don't match.":''}}</span>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Save Change</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-5-->
            </div>
        </div>
    
@endsection
