@extends('layouts.backend')
@section('title')
    Admin | Message
@endsection

@section('extra_css')

@endsection

@section('extra_js')

@endsection

@section('content')
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="card">
                            <div class="card-header py-3 align-items-center justify-content-between">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="m-0 font-weight-bold text-primary">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                 class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                                 viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                                 stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <rect x="4" y="4" width="6" height="6" rx="1"/>
                                                <rect x="4" y="14" width="6" height="6" rx="1"/>
                                                <rect x="14" y="14" width="6" height="6" rx="1"/>
                                                <line x1="14" y1="7" x2="20" y2="7"/>
                                                <line x1="17" y1="4" x2="17" y2="10"/>
                                            </svg>
                                            Message View <a href="{{ route('message.index') }}" style="color: #f55f5f;font-weight: 300;">(Back)</a>
                                        </h6>
                                    </div>
                                    <div class="col-md-6">
                                        <a href="{{ route('message.index') }}" class="btn btn-primary float-right">All Message</a>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <tbody>
                                    @if($item)
                                        <tr>
                                            <th>Name</th>
                                            <td>{{$item->name}}</td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td>{{$item->email}}</td>
                                        </tr>
                                        <tr>
                                            <th>Phone</th>
                                            <td>{{$item->phone}}</td>
                                        </tr>
                                        <tr>
                                            <th>Subject</th>
                                            <td>{{$item->subject}}</td>
                                        </tr>
                                        <tr>
                                            <th>Message</th>
                                            <td>{!!$item->message!!}</td>
                                        </tr>
                                        <tr>
                                            <th>Time</th>
                                            <td>{{Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $item->created_at)->format('H:i/d-m-Y')}}</td>
                                        </tr>
                                        <tr>
                                            <th>Delete</th>
                                            <td><a title="delete" href="{{ route('message.destroy', ['id' => $item->id])}}"  onclick="return confirm('Are you sure to delete this!')" class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                                
                            </div>
                        </div>
                </div>
            </div>
        </div>
@endsection


